
use builtin;
use str;

set edit:completion:arg-completer[ncspot] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'ncspot'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'ncspot'= {
            cand -d 'Enable debug logging to the specified file'
            cand --debug 'Enable debug logging to the specified file'
            cand -b 'custom basepath to config/cache files'
            cand --basepath 'custom basepath to config/cache files'
            cand -c 'Filename of config file in basepath'
            cand --config 'Filename of config file in basepath'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand info 'Print platform information like paths'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ncspot;info'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'ncspot;help'= {
            cand info 'Print platform information like paths'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'ncspot;help;info'= {
        }
        &'ncspot;help;help'= {
        }
    ]
    $completions[$command]
}
