/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.event.base;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.base.RepositoryConnectionWrapper;
import org.openrdf.repository.event.NotifyingRepositoryConnection;
import org.openrdf.repository.event.RepositoryConnectionListener;

public class NotifyingRepositoryConnectionWrapper
extends RepositoryConnectionWrapper
implements NotifyingRepositoryConnection {
    private boolean activated = false;
    private boolean reportDeltas = false;
    private Set<RepositoryConnectionListener> listeners = new CopyOnWriteArraySet<RepositoryConnectionListener>();

    public NotifyingRepositoryConnectionWrapper(Repository repository, RepositoryConnection connection) {
        super(repository, connection);
    }

    public NotifyingRepositoryConnectionWrapper(Repository repository, RepositoryConnection connection, boolean reportDeltas) {
        this(repository, connection);
        this.setReportDeltas(reportDeltas);
    }

    public boolean reportDeltas() {
        return this.reportDeltas;
    }

    public void setReportDeltas(boolean reportDeltas) {
        this.reportDeltas = reportDeltas;
    }

    public void addRepositoryConnectionListener(RepositoryConnectionListener listener) {
        this.listeners.add(listener);
        this.activated = true;
    }

    public void removeRepositoryConnectionListener(RepositoryConnectionListener listener) {
        this.listeners.remove(listener);
        this.activated = !this.listeners.isEmpty();
    }

    protected boolean isDelegatingAdd() {
        return !this.activated;
    }

    protected boolean isDelegatingRemove() {
        return !this.activated;
    }

    public void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        boolean reportEvent = this.activated;
        if (reportEvent && this.reportDeltas()) {
            reportEvent = !this.getDelegate().hasStatement(subject, predicate, object, false, contexts);
        }
        this.getDelegate().add(subject, predicate, object, contexts);
        if (reportEvent) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.add(this, subject, predicate, object, contexts);
            }
        }
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        if (this.activated && this.reportDeltas()) {
            this.removeWithoutCommit(null, null, null, contexts);
        } else if (this.activated) {
            this.getDelegate().clear(contexts);
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.clear(this, contexts);
            }
        } else {
            this.getDelegate().clear(contexts);
        }
    }

    public void close() throws RepositoryException {
        super.close();
        if (this.activated) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.close(this);
            }
        }
    }

    public void commit() throws RepositoryException {
        this.getDelegate().commit();
        if (this.activated) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.commit(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWithoutCommit(Resource subj, URI pred, Value obj, Resource ... ctx) throws RepositoryException {
        if (this.activated && this.reportDeltas()) {
            RepositoryResult<Statement> stmts = this.getDelegate().getStatements(subj, pred, obj, false, ctx);
            ArrayList<Statement> list = new ArrayList<Statement>();
            try {
                while (stmts.hasNext()) {
                    list.add(stmts.next());
                }
            }
            finally {
                stmts.close();
            }
            this.getDelegate().remove(subj, pred, obj, ctx);
            for (RepositoryConnectionListener listener : this.listeners) {
                for (Statement stmt : list) {
                    Resource s = stmt.getSubject();
                    URI p = stmt.getPredicate();
                    Value o = stmt.getObject();
                    Resource c = stmt.getContext();
                    listener.remove(this, s, p, o, c);
                }
            }
        } else if (this.activated) {
            this.getDelegate().remove(subj, pred, obj, ctx);
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.remove(this, subj, pred, obj, ctx);
            }
        } else {
            this.getDelegate().remove(subj, pred, obj, ctx);
        }
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        this.getDelegate().removeNamespace(prefix);
        if (this.activated) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.removeNamespace(this, prefix);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNamespaces() throws RepositoryException {
        if (this.activated && this.reportDeltas()) {
            RepositoryResult<Namespace> namespaces = this.getDelegate().getNamespaces();
            ArrayList<String> prefix = new ArrayList<String>();
            try {
                while (namespaces.hasNext()) {
                    Namespace ns = namespaces.next();
                    prefix.add(ns.getPrefix());
                }
            }
            finally {
                namespaces.close();
            }
            this.getDelegate().clearNamespaces();
            for (String p : prefix) {
                this.removeNamespace(p);
            }
        } else if (this.activated) {
            this.getDelegate().clearNamespaces();
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.clearNamespaces(this);
            }
        } else {
            this.getDelegate().clearNamespaces();
        }
    }

    public void rollback() throws RepositoryException {
        this.getDelegate().rollback();
        if (this.activated) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.rollback(this);
            }
        }
    }

    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        boolean wasAutoCommit = this.isAutoCommit();
        this.getDelegate().setAutoCommit(autoCommit);
        if (this.activated && wasAutoCommit != autoCommit) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.setAutoCommit(this, autoCommit);
            }
            if (autoCommit) {
                for (RepositoryConnectionListener listener : this.listeners) {
                    listener.commit(this);
                }
            }
        }
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        this.getDelegate().setNamespace(prefix, name);
        if (this.activated) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.setNamespace(this, prefix, name);
            }
        }
    }
}

