/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                               A - M I S C                                */
/*                                                                          */
/*                          C Implementation File                           */
/*                                                                          */
/*                             $Revision: 1.67 $                            */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

#include "config.h"
#include <stdio.h>
#include <string.h>
#include "tree.h"
#include "rtl.h"
#include "expr.h"
#include "a-ada.h"
#include "a-types.h"
#include "a-atree.h"
#include "a-nlists.h"
#include "a-elists.h"
#include "a-sinfo.h"
#include "a-einfo.h"
#include "a-namet.h"
#include "a-string.h"
#include "a-uintp.h"
#include "a-gtran3.h"
#include "a-trans.h"
#include "a-trans3.h"
#include "a-trans4.h"
#include "a-misc.h"
#include "a-rtree.h"
#include "flags.h"

extern char *xmalloc ();
extern char *main_input_filename;

/* Tables describing GCC tree codes used only by GNAT.  

   Table indexed by tree code giving a string containing a character
   classifying the tree code.  Possibilities are
   t, d, s, c, r, <, 1 and 2.  See cp-tree.def for details.  */

#define DEFTREECODE(SYM, NAME, TYPE, LENGTH) TYPE,

char *gnat_tree_code_type[] = {
  "x",
#include "a-tree.def"
};
#undef DEFTREECODE

/* Table indexed by tree code giving number of expression
   operands beyond the fixed part of the node structure.
   Not used for types or decls.  */

#define DEFTREECODE(SYM, NAME, TYPE, LENGTH) LENGTH,

int gnat_tree_code_length[] = {
  0,
#include "a-tree.def"
};
#undef DEFTREECODE

/* Names of tree components.
   Used for printing out the tree and error messages.  */
#define DEFTREECODE(SYM, NAME, TYPE, LEN) NAME,

char *gnat_tree_code_name[] = {
  "@@dummy",
#include "a-tree.def"
};
#undef DEFTREECODE

/* gnat standard argc argv */

extern int gnat_argc;
extern char **gnat_argv;

/* Root node of the tree read in.  Used only by yyparse.  */
Node_Id gnat_root;

/* Global Variables Expected by gcc: */

char *language_string = "GNU Ada";
int current_function_returns_null;
int flag_traditional;		/* Used by dwarfout.c.  */

/* Routines Expected by gcc:  */

/* For most front-ends, this is the parser for the language.  For us, we
   process the GNAT tree.  */

int
yyparse ()
{
  /* Make up what Gigi uses as a jmpbuf.  */
  size_t jmpbuf[100];

  /* Call the front-end elaboration procedures */
  ada__bind ();

  /* Set up to catch unhandled exceptions.  */
  if (setjmp (jmpbuf))
    abort ();

  system__task_specific_data__set_jmpbuf_address (jmpbuf);

  immediate_size_expand = 1;

  /* Call the front end */
  _ada_gnat1drv ();

  return 0;
}

/* init gnat_argc and gnat_argv */

void 
init_gnat_args ()
{
  extern int save_argc;

  /* initialize gnat_argv with save_argv size */
  gnat_argv = (char **) malloc ((save_argc + 1) * sizeof (gnat_argv[0])); 

  /* leave the 2 first slots in gnat_argv for the program name and 
     the main source name */

  gnat_argc = 2;
}

/* Decode all the language specific options that cannot be decoded by GCC. The
   option decoding phase of GCC calls this routine on the flags that it cannot
   decode. This routine returns 1 if it is successful, otherwise it
   returns 0. */

int
lang_decode_option (p)
     char *p;
{
#if defined (WINNT) || defined (__EMX__)
  if (strnicmp (p, "-gnat", 5))
#else
  if (strncasecmp (p, "-gnat", 5))
#endif
    /* we assume for the moment that all front end options are passed
       with "gnat" prefix */
    return 0;
  else
    {
      if (!gnat_argc) init_gnat_args ();

      /* recopy the switches without the 'gnat' prefix */

      gnat_argv[gnat_argc] =  (char *) malloc (strlen (p) - 3);
      gnat_argv[gnat_argc][0] = '-';
      strcpy (gnat_argv[gnat_argc] + 1, p + 5);
      gnat_argc ++;
      return 1;
    }
}

/* Perform all the initialization steps that are language-specific.  */

void
lang_init ()
{
  extern char **save_argv;

  if (!gnat_argc) init_gnat_args ();

  gnat_argv [0] = save_argv[0];     /* name of the command */ 
  gnat_argv [1] = input_filename;   /* name of the main source */
  gnat_argv [gnat_argc] = 0;      /* end of argv */

  main_input_filename = input_filename;

}

/* Perform all the finalization steps that are language-specific.  */

void
lang_finish ()
{}

/* Return a short string identifying this language to the debugger.  */

char *
lang_identify ()
{
  return "ada";
}

/* If DECL has a cleanup, build and return that cleanup here.
   This is a callback called by expand_expr.  */

tree
maybe_build_cleanup (decl)
     tree decl;
{
  /* There are no cleanups in C.  */
  return NULL_TREE;
}

/* Print any language-specific compilation statistics.  */

void
print_lang_statistics ()
{}

/* integrate_decl_tree calls this function, but since we don't use the
   DECL_LANG_SPECIFIC field, this is a no-op.  */

void
copy_lang_decl (node)
     tree node;
{
}

/* Hooks for print-tree.c:  */

void
print_lang_decl (file, node, indent)
     FILE *file;
     tree node;
     int indent;
{}

void
print_lang_type (file, node, indent)
     FILE *file;
     tree node;
     int indent;
{
  if (TREE_CODE (node) == FUNCTION_TYPE && TYPE_CI_CO_LIST (node))
    print_node (file, "ci_co_list", TYPE_CI_CO_LIST (node), indent + 4);
  else if (TREE_CODE (node) == INTEGER_TYPE && TYPE_MODULAR_P (node)
	   && TYPE_MODULUS (node))
    print_node (file, "modulus", TYPE_MODULUS (node), indent + 4);
  else if (TREE_CODE (node) == INTEGER_TYPE && TYPE_INDEX_TYPE (node))
    print_node (file, "index type", TYPE_INDEX_TYPE (node), indent + 4);
  else if (TREE_CODE (node) == RECORD_TYPE && TYPE_FAT_POINTER_P (node)
	   && TYPE_UNCONSTRAINED_ARRAY (node))
    print_node (file, "unconstrained array",
		TYPE_UNCONSTRAINED_ARRAY (node), indent + 4);
  else if (TREE_CODE (node) == RECORD_TYPE && TYPE_PARENT_SUBTYPE (node))
    print_node (file, "parent subtype",
		TYPE_PARENT_SUBTYPE (node), indent + 4);
}

void
print_lang_identifier (file, node, indent)
     FILE *file;
     tree node;
     int indent;
{}

/* Expands GNAT-specific GCC tree nodes.  The only ones we support here are
   TRANSFORM_EXPR, UNCHECKED_CONVERT_EXPR, and NULL_EXPR.  */

static rtx
gnat_expand_expr (exp, target, tmode, modifier)
     tree exp;
     rtx target;
     enum machine_mode tmode;
     enum expand_modifier modifier;
{
  tree type = TREE_TYPE (exp);
  tree new;
  rtx result;

  /* Update EXP to be the new expression to expand.  */

  switch (TREE_CODE (exp))
    {
    case TRANSFORM_EXPR:
      /* If we will ignore our result, just generate code.  Otherwise,
	 expand it.  */
      if (target == const0_rtx || TREE_CODE (type) == VOID_TYPE)
	{
	  gnat_to_code (TREE_COMPLEXITY (exp));
	  return target;
	}

      new = gnat_to_gnu (TREE_COMPLEXITY (exp));

      /* If we were to take the address of this node, do it now.  */
      if (TREE_TRANSFORM_ADDR (exp))
	new = build_unary_op (ADDR_EXPR, NULL_TREE, new);

      /* If convert was called on this TRANSFORM_EXPR, it will now have a type,
	 so we must do the conversion now.  */
      if (type != error_mark_node)
	new = convert (type, new);
      break;

    case UNCHECKED_CONVERT_EXPR:
      /* If the input and output are both the same mode (usually BLKmode),
	 just return the expanded input since we want just the bits.  */
      if (TYPE_MODE (type) == TYPE_MODE (TREE_TYPE (TREE_OPERAND (exp, 0))))
	new = TREE_OPERAND (exp, 0);

      /* If either mode is BLKmode, memory will be involved, so do this
	 via pointer punning.  */
      else if (TYPE_MODE (type) == BLKmode
	       || TYPE_MODE (TREE_TYPE (TREE_OPERAND (exp, 0))) == BLKmode)
	new
	  = build_unary_op (INDIRECT_REF, NULL_TREE,
			    convert (build_pointer_type (type),
				     build_unary_op (ADDR_EXPR, NULL_TREE,
						     TREE_OPERAND (exp, 0))));

      /* Otherwise make a union of the two types, convert to the union, and
	 extract the other value.  */
      else
	{
	  /* Note that copy_node puts objects in current_obstack and we
	     take advantage of that here since we want these objects to
	     all be in the momentary obstack.  */
	  tree in_type = TREE_TYPE (TREE_OPERAND (exp, 0));
	  tree union_type = copy_node (unchecked_union_node);
	  tree in_field
	    = create_field_decl ("in", in_type, union_type, 0, -1, 0);
	  tree out_field
	    = create_field_decl ("out", type, union_type, 0, -1, 0);

	  TYPE_MAIN_VARIANT (union_type) = union_type;
	  finish_record_type (union_type,
			      chainon (chainon (NULL_TREE, in_field),
				       out_field),
			      0);

	  new = build (COMPONENT_REF, type,
		       build1 (CONVERT_EXPR, union_type,
			       TREE_OPERAND (exp, 0)),
		       out_field);
	}
      break;

    case NULL_EXPR:
      expand_expr (TREE_OPERAND (exp, 0), const0_rtx, VOIDmode, 0);

      /* Now make a temporary RTL the same as expr.c does.  For
	 now, don't support variable-sized objects.  */
      if (TYPE_MODE (type) == BLKmode || TREE_ADDRESSABLE (type))
	{
	  int size = int_size_in_bytes (type);
	  rtx tem;

	  if (size == -1)
	    gigi_abort (202);

	  tem = assign_stack_temp (TYPE_MODE (type), size, 0);
	  MEM_IN_STRUCT_P (tem) = AGGREGATE_TYPE_P (type);
	  return tem;
	}
      else
	{
	  int unsignedp = TREE_UNSIGNED (type);

	  return gen_reg_rtx (promote_mode (type, TYPE_MODE  (type),
					    &unsignedp, 0));
	}

    case USE_EXPR:
      if (target != const0_rtx)
	gigi_abort (203);

      /* First write a volatile ASM_INPUT to prevent anything from being
	 moved.  */
      result = gen_rtx (ASM_INPUT, VOIDmode, "");
      MEM_VOLATILE_P (result) = 1;
      emit_insn (result);

      result = expand_expr (TREE_OPERAND (exp, 0), NULL_RTX, VOIDmode,
			    modifier);
      emit_insn (gen_rtx (USE, VOIDmode, result));
      return target;

    case UNCONSTRAINED_ARRAY_REF:
      /* If we are evaluating just for side-effects, just evaluate our
	 operand.  Otherwise, abort since this code should never appear
	 in a tree to be evaluated (objects aren't unconstrained).  */
      if (target == const0_rtx || TREE_CODE (type) == VOID_TYPE)
	return expand_expr (TREE_OPERAND (exp, 0), const0_rtx,
			    VOIDmode, modifier);

      /* ... fall through ... */

    default:
      gigi_abort (201);
    }

  return expand_expr (new, target, tmode, modifier);
}

/* Make a TRANSFORM_EXPR to later expand GNAT_NODE into an object
   of GNU_TYPE.  */

tree
make_transform_expr (gnat_node, gnu_type)
     Node_Id gnat_node;
     tree gnu_type;
{
  tree gnu_result = build (TRANSFORM_EXPR, gnu_type);

  TREE_SIDE_EFFECTS (gnu_result) = 1;
  TREE_COMPLEXITY (gnu_result) = gnat_node;
  return gnu_result;
}

/* Performs whatever initialization steps needed by the language-dependent
   lexical analyzer.

   Define the additional tree codes here.  This isn't the best place to put
   it, but it's where g++ does it.  */

void
init_lex ()
{
  lang_expand_expr = gnat_expand_expr;

  tree_code_type
    = (char **) realloc (tree_code_type,
			 sizeof (char *) * LAST_GNAT_TREE_CODE);
  tree_code_length
    = (int *) realloc (tree_code_length,
		       sizeof (int) * LAST_GNAT_TREE_CODE);
  tree_code_name
    = (char **) realloc (tree_code_name,
			 sizeof (char *) * LAST_GNAT_TREE_CODE);

  bcopy ((char *) gnat_tree_code_type,
	 (char *) (tree_code_type + (int) LAST_AND_UNUSED_TREE_CODE),
	 ((LAST_GNAT_TREE_CODE - (int) LAST_AND_UNUSED_TREE_CODE)
	  * sizeof (char *)));

  bcopy ((char *)gnat_tree_code_length,
	 (char *) (tree_code_length + (int) LAST_AND_UNUSED_TREE_CODE),
	 ((LAST_GNAT_TREE_CODE - (int) LAST_AND_UNUSED_TREE_CODE)
	  * sizeof (int)));

  bcopy ((char *) gnat_tree_code_name,
	 (char *) (tree_code_name + (int) LAST_AND_UNUSED_TREE_CODE),
	 ((LAST_GNAT_TREE_CODE - (int) LAST_AND_UNUSED_TREE_CODE)
	  * sizeof (char *)));
}

/* Sets some debug flags for the parsed. It does nothing here.  */

void
set_yydebug (value)
     int value;
{}


/* Override the regular abort to call gigi_abort since it gives more useful
   crash error messages.  If abort is a macro, we can't do this.  */

#ifndef abort

void
abort ()
{
  gigi_abort (999);
}
#endif

/* Return the alignment for GNAT_TYPE.  */

int
get_type_alignment (gnat_type)
     Entity_Id gnat_type;
{
  return TYPE_ALIGN (gnat_to_gnu_type (gnat_type)) / BITS_PER_UNIT;
}

/* Utility Routines needed by the Tree Translator: */

/* GNU_TYPE is the type of a subprogram parameter.  Determine from the type if
   it should be passed by reference.  */

int
pass_by_ref (gnu_type)
     tree gnu_type;
{
  /* We pass only BLKmode and unconstrained objects by reference.  */
  return (TREE_CODE (gnu_type) == UNCONSTRAINED_ARRAY_TYPE
	  || TYPE_MODE (gnu_type) == BLKmode);
}
