# Include-File fr Acorn RISC OS - Version von CLISP
# Bruno Haible, Peter Burwood 20.12.1994

# Konstanten fr Steuerzeichen:

#define BEL  7              # Ton ausgeben
# define NL  10             # New line, siehe LISPBIBL.D
#define RUBOUT 127          # Rubout = Delete
#define CRLFstring  "\n"    # C-String, der BS-Newline enthlt

#define stdin_handle   0  # File-Handle von Standard-Input
#define stdout_handle  1  # File-Handle von Standard-Output

# Deklaration von Typen von Ein-/Ausgabe-Parametern von Betriebssystemfunktionen
  #include <stdlib.h>
  #include <sys/types.h>
  #include <unistd.h>
  #define RETSTRLENTYPE size_t
  #define STRLEN_CONST const

# Tabelle der System-Fehlermeldungen
  #include <errno.h>
  # extern volatile int errno; # letzter Fehlercode
  extern int sys_nerr; # Anzahl der Betriebssystem-Fehlermeldungen
  extern char* sys_errlist[]; # Betriebssystem-Fehlermeldungen
  # siehe <errno.h>, PERROR(3)
# wird verwendet von ERROR, SPVW, STREAM, PATHNAME

# Bereitstellen des Arbeitsspeichers
  extern void* malloc (size_t size);
  extern void free (void* ptr);
  extern void* realloc (void* ptr, size_t size);
  # siehe <stdlib.h>
# wird verwendet von SPVW, STREAM

# Normales Programmende
  nonreturning_function(extern, _exit, (int status)); # siehe EXIT(2V)
# wird verwendet von SPVW, PATHNAME, STREAM

# Sofortiger Programmabbruch, Sprung in den Debugger
  extern void abort (void); # siehe ABORT(3)
  # siehe <stdlib.h>
# wird verwendet von SPVW, DEBUG, EVAL, IO

# Signalbehandlung
  #include <signal.h>
  # Ein Signal-Handler ist eine Funktion ohne Ergebnis.
  typedef void (*signal_handler) ();
  extern signal_handler signal (int sig, signal_handler handler); # siehe SIGNAL(3V)
  #define SIGNAL_NEED_REINSTALL
  #define signal_acknowledge(sig,handler)  nowarn signal(sig,handler) # Handler bleibt weiter aktiv
  #define siginterrupt(sig,flag)
  #define SIGNAL(sig,handler)  nowarn signal(sig,handler)
# wird verwendet von SPVW

# Environment-Variablen abfragen:
  extern char* getenv (const char* name); # siehe GETENV(3V)
  # siehe <stdlib.h>
# wird verwendet von PATHNAME, SPVW, MISC

# Working Directory setzen:
  extern int chdir (char* path); # siehe CHDIR(2V)
  # siehe <unistd.h>
# wird verwendet von PATHNAME

# Working Directory abfragen:
  #if 0 # unbrauchbar, da es einen Pfad im Unix-Format liefert
    #include <sys/param.h> # definiert MAXPATHLEN
    extern char* getcwd (char* buf, int bufsize);
    #define getwd(buf)  getcwd(buf,MAXPATHLEN)
    # siehe <unistd.h>
  #endif
  # Benutze stattdessen die Funktionen os_fopen(), os_fclose(), os_swi().
# wird verwendet von PATHNAME

# Information zu einem File erfragen:
  #include <sys/types.h>
  #include <sys/stat.h>
  extern int stat (char* path, struct stat * buf); # siehe STAT(2V)
  #define lstat stat
  #define S_ISLNK(m)  FALSE
  extern int fstat (int fd, struct stat * buf); # siehe STAT(2V)
  #ifndef S_ISDIR
    #define S_ISDIR(m)  (((m)&S_IFMT) == S_IFDIR)
  #endif
  #ifndef S_ISLNK
    #define S_ISLNK(m)  (((m)&S_IFMT) == S_IFLNK)
  #endif
  #ifndef S_ISREG
    #define S_ISREG(m)  (((m)&S_IFMT) == S_IFREG)
  #endif
  # siehe <unistd.h>
# wird verwendet von PATHNAME, STREAM, SPVW

# File lschen:
  extern int unlink (char* path); # siehe UNLINK(2V)
  # siehe <unistd.h>
# wird verwendet von PATHNAME

# File umbenennen:
  extern int rename (const char* oldpath, const char* newpath); # siehe RENAME(2V)
  # siehe <stdio.h>
# wird verwendet von PATHNAME

# Directory-Suche:
  #include <dirent.h>
  #define SDIRENT  struct dirent
  #if 0 # Die allgemeinen Routinen
    #define DIRENT_WITHOUT_NAMLEN  # d_namlen includes the trailing null byte
    #define d_reclen  d_namlen
    extern DIR* opendir (char* dirname); # siehe DIRECTORY(3V)
    extern SDIRENT* readdir (DIR* dirp); # siehe DIRECTORY(3V)
    extern int closedir (DIR* dirp); # siehe DIRECTORY(3V)
  #else # Die Routinen, die wir benutzen, sind die in acornaux.d.
    #define opendir  my_opendir  # <dirent.h> deklariert opendir() bereits...
    #define readdir  my_readdir
    #define closedir  my_closedir
    extern DIR* opendir (const char* dirname, const char* wildname);
    extern SDIRENT* readdir (DIR* dirp);
    extern int closedir (DIR* dirp);
  #endif
  #define CLOSEDIR  closedir
# wird verwendet von PATHNAME

# Directory anlegen:
  extern int mkdir (char* path);
  #define mkdir(path,attrib)  (mkdir)(path)
# wird verwendet von PATHNAME

# Directory lschen:
  #if 0 # lscht auch nichtleere Directories, viel zu gefhrlich!
    extern int rmdir (char* path); # siehe RMDIR(2V)
    # siehe <unistd.h>
  #endif
# wird verwendet von PATHNAME

# Arbeiten mit offenen Files:
  #include <sys/types.h>
  # include <unistd.h> # siehe oben
  #include <fcntl.h>
  extern int open (char* path, int flags, ...); # siehe OPEN(2V)
  #define my_open_mask  0644
  #define Handle  uintW  # Typ eines File-Deskriptors
  extern long lseek (int fd, long offset, int whence); # siehe LSEEK(2V)
  #include <stdio.h> # definiert SEEK_SET, SEEK_CUR, SEEK_END
  extern int read (int fd, void* buf, int nbyte); # siehe READ(2V)
  extern int write (int fd, void* buf, int nbyte); # siehe WRITE(2V)
  extern int close (int fd); # siehe CLOSE(2V)
  # siehe <unistd.h>
  #define OPEN open
  #define CLOSE close
  # Wrapper um die System-Aufrufe, die Teilergebnisse und evtl. EINTR behandeln:
  extern int full_read (int fd, char* buf, int nbyte);
  extern int full_write (int fd, char* buf, int nbyte);
  #define RETRWTYPE  int
  #define RW_BUF_T  void*
  #define RW_SIZE_T  int
  #define WRITE_CONST
# wird verwendet von STREAM, PATHNAME, SPVW, MISC

# Terminal-Abfragen, Abfragen der Fenster-Gre:
  extern int isatty (int fd); # siehe TTYNAME(3V)
  extern int ioctl (int fd, int request, void* arg); # siehe IOCTL(2)
  # siehe <unistd.h>
  #define UNIX_TERM_TERMIO
  #include <termio.h>
  extern int fcntl (int fd, int cmd, int arg); # siehe FCNTL(2V)
  # siehe <unistd.h>
  extern int tgetent (char* bp, char* name); # siehe TERMCAP(3X)
  extern int tgetnum (char* id); # siehe TERMCAP(3X)
  extern int tgetflag (char* id); # siehe TERMCAP(3X)
  extern char* tgetstr (char* id, char** area); # siehe TERMCAP(3X)
  # siehe <termcap.h>
  #ifndef NCCS
    #define NCCS  sizeof(((struct termio *)0)->c_cc)
  #endif
# wird verwendet von SPVW, STREAM

# Datum/Uhrzeit verarbeiten:
  #include <time.h>
  extern time_t time (time_t* clock); # siehe TIME(3V)
  extern struct tm * localtime (const time_t* clock); # siehe CTIME(3V)
  extern struct tm * gmtime (const time_t* clock); # siehe CTIME(3V)
# wird verwendet von SPVW, MISC

# Datum/Uhrzeit abfragen:
  #include <time.h> # fr CLK_TCK ntig
  #include <sys/times.h>
  #define CLOCK_T  clock_t
  extern CLOCK_T times (struct tms * buffer); # siehe TIMES(3V)
  extern time_t time (time_t* tloc); # siehe TIME(3V)
# wird verwendet von SPVW, MISC

# Eine bestimmte Zeit Pause machen:
  extern int sleep (unsigned int seconds);
  # siehe <unistd.h>
# wird verwendet von MISC

# Programme aufrufen:
  extern int execv (char* path, char* argv[]); # siehe EXECL(3V)
  extern int execl (char* path, ...); # siehe EXECL(3V)
  extern int execlp (char* path, ...); # siehe EXECL(3V)
  extern int wait (int* statusp);
  # siehe <unistd.h>
  #define PID_T  int  # fr unixaux.d
# extern int wait2 (PID_T pid); # siehe unixaux.d
# wird verwendet von STREAM, PATHNAME, SPVW

