#include <stdlib.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <NumEntry.h>
#include <stdio.h>

#ifdef HAS_STROKE
#include <Stroke.h>
#endif

static char *FallBack[] =
{
#ifdef HAS_STROKE
	"*.strokes: 654 ManagerParentCancel, 456 ManagerParentActivate",
	"*NumEntry1.strokes: 852 Up, 258 Down, 456 Up, 654 Down",
	"*XmDialogShell*translations: #override" DEFAULT_STROKE_TRANSLATIONS,
#endif
	NULL
};

void
debug()
{
}

static void
LosingFocus()
{
	printf("LosingFocus()\n");
}

static void
Activate()
{
	printf("Activate()\n");
}

static void
ValueChange(Widget w, XtPointer client_data, XltNumEntryVerifyCallbackStruct *cbs)
{
String value;
double Value;
char buf[1024];

	/*
	XtVaGetValues(w,
		XmNvalue, &value,
		NULL);
	Value = atof(value);
	*/
	sprintf(buf,"%09.4f", cbs->dvalue);
	XtFree(cbs->value);
	cbs->value = XtNewString(buf);
	printf("ValueChange(%s) - %s %s\n", XtName(w), cbs->value, cbs->value);
	//XtFree(value);
}

char *Program = "";
int
main(int argc, char **argv)
{
  Widget toplevel, one;
  XtAppContext app;

  XtSetLanguageProc(NULL, NULL, NULL);

  toplevel = XtVaAppInitialize(&app, "NumEntryTest", NULL, 0, &argc, argv, FallBack, NULL);

  one = XltCreateNumEntry(toplevel, "NumEntry1", NULL, 0);
#ifdef HAS_STROKE
  StrokeInitialize(toplevel);
#endif
  XtAddCallback(one, XmNlosingFocusCallback, (void *)LosingFocus, (XtPointer)NULL);
  XtAddCallback(one, XmNactivateCallback, (void *)Activate, (XtPointer)NULL);
  XtAddCallback(one, XmNvalueChangedCallback, (void *)ValueChange, (XtPointer)NULL);
  XtManageChild(one);

  XtRealizeWidget(toplevel);
  XtAppMainLoop(app);

  exit(0);
}
