/*
 *  desktop -- The 3dfx Desktop Demo 
 *  COPYRIGHT 3DFX INTERACTIVE, INC. 1999
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* This function calculates the difference in microseconds between
 * two timevals
 * Computes: t1 - t2
 */
#include <sys/time.h>

time_t
timeval_sub (struct timeval *t1, struct timeval *t2)
{
  time_t temp;

  /* Get difference in seconds */
  temp = (t1->tv_sec - t2->tv_sec) * 1000000;
  /* Add on the difference in microseconds */
  temp += t1->tv_usec - t2->tv_usec;

  return (temp);
}
