/*     
 **********************************************************************
 *     cardmo.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 *     November 2, 1999     Alan Cox	    cleaned up
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */ 

#ifndef _CARDMO_H
#define _CARDMO_H

#include "icardmid.h"

#define IDS_EMU_MIDIOUT_PNAME        "SB Live! MIDI Out"
#define CARDMIDIOUT_STATE_DEFAULT    0x00000000
#define CARDMIDIOUT_STATE_SUSPEND    0x00000001

struct sblive_mpuout
{
        u32			status;
	u32			state;
	volatile int		intr;
	struct midi_queue	*firstmidiq;
	struct midi_queue	*lastmidiq;
	u8			laststatus;
	CTDPC			dpc;
	spinlock_t		lock;
	struct midi_caps	caps;
	struct midi_openinfo	openinfo;
};

int sblive_mpuoutInit(struct sblive_mpuout *, struct sblive_hw *);
int sblive_mpuoutExit(struct sblive_hw *);

int sblive_mpuoutOpen(struct sblive_hw *, struct midi_openinfo *, u32 *);
int sblive_mpuoutClose(struct sblive_hw *, u32);
int sblive_mpuoutAddBuffer(struct sblive_hw *, u32, struct midi_hdr *);
int sblive_mpuoutWriteShortData(struct sblive_hw *, u32, u32);

int sblive_mpuoutIrqCallback(unsigned long event, unsigned long refdata, unsigned long param);
int sblive_mpuoutDpcCallback(unsigned long refdata, unsigned long param1, unsigned long param2);

#endif  /* _CARDMO_H */

