;;; low pass fir filter with cut off at 0.05pi

	include "emu_constants.asm"

	
;;; our coefficients:
c0 dc $76019a
c1 dc $101449b
c2 dc $273fb70
c3 dc $44b5653
c4 dc $5d05328
c5 dc $6666666
c6 dc $5d05328
c7 dc $44b5653
c8 dc $273fb70
c9 dc $101449b 

	
;;; our delay lines:
dl1 ds 1
dl2 ds 1
dl3 ds 1
dl4 ds 1
dl5 ds 1
dl6 ds 1
dl7 ds 1
dl8 ds 1
dl9 ds 1

dr1 ds 1
dr2 ds 1
dr3 ds 1
dr4 ds 1
dr5 ds 1
dr6 ds 1
dr7 ds 1
dr8 ds 1
dr9 ds 1


	
outl equ $020
outr equ $021	
acc equ $056	
zero equ C_0	
scale equ C_8  A scaling factor for our filter

	
;;;our filter for the left channel
	mac_s	acc,zero,zero,zero ; clears the accumulator
	
	macmv	dl9,dl8,dl9,c9
	macmv	dl8,dl7,dl8,c8
	macmv	dl7,dl6,dl7,c7
	macmv	dl6,dl5,dl6,c6
	macmv	dl5,dl4,dl5,c5
	macmv	dl4,dl3,dl4,c4
	macmv	dl3,dl2,dl3,c3
	macmv	dl2,dl1,dl2,c2
	macmv	dl1,outl,dl1,c1
	mac_S outl,acc,outl,c0
	
	macint_s outl,zero,outl,scale    scales the filter
	

;;;our filter for the right channel
	
	mac_s	acc,zero,zero,zero ; clears the accumulator
		
	macmv	dr9,dr8,dr9,c9
	macmv	dr8,dr7,dr8,c8
	macmv	dr7,dr6,dr7,c7
	macmv	dr6,dr5,dr6,c6
	macmv	dr5,dr4,dr5,c5
	macmv	dr4,dr3,dr4,c4
	macmv	dr3,dr2,dr3,c3
	macmv	dr2,dr1,dr2,c2
	macmv	dr1,outr,dr1,c1
	mac_S   outr,acc,outr,c0	 		

	macint_s  outr,zero,outr,scale  scales the filter
	
	
	
	end

from the above we can see that it would greatly help if the "For" directive
was implemented, can you imagine doing that for an FIR filter with n=50?
