;;; Simple Stereo flanger
;;; Author:Daniel Bertrand
;;; Date: May 29,2000

;;; This program is free software; you can redistribute it and/or modify  
;;; it under the terms of the GNU General Public License as published by  
;;; the Free Software Foundation; either version 2 of the License, or     
;;; (at your option) any later version.

;;; References:	
;;; http://www.harmony-central.com/Effects/Articles/Flanging/
		
;;; in octave :	delta=dec2hex(round(2*pi*freq/48000*(2^31-1)))
;;;  this give us our delta value for a specific freq (0.1-0.3Hz is good)
		

	include "emu_constants.asm"

outl equ $020
outr equ $021
acrec  equ $010

;; note: all tram addresses must be multiplied by 2^11 = $800
		
delta    dc $a4b6 	; controls frequency
dcdelay  dc $48000      ; average delay 			
width    dc $20000	; width control
forward  dc $40000000	; forward mix
feedback dc $30000000	;feedback level 

;; sine generator storage spaces:	
sinx  dc  0	
cosx  equ width

;; offset to delay lines

Roffset dc $0		
Loffset dc $800000

		
Rsource ds 1	
Lsource ds 1	

;;; Delay Lines:

	orgd $200
Rwrite ds 1
Rread ds 1			
Lwrite ds 1
Lread ds 1	
		
	orgd $300
	
Rwriteaddr dc $200000		
Rreadaddr  dc $100000	  ;we'll write the address on the fly 
Lwriteaddr dc $201000		
Lreadaddr  dc $100000	  ;again, on the fly 

;;;The code:	
	
		
;;; two opcode sinewave generator (I love this chip!):
	mac_s  sinx,sinx,delta,cosx       
	mac_1s cosx,cosx,delta,sinx 

	
;;; sources:	
	mac_s  Rsource,outr,acrec,C_2^29
	mac_s  Lsource,outl,acrec,C_2^29 

;;; calculate address:		
	
	acc3  Rreadaddr,dcdelay,sinx,Roffset 
	acc3  Lreadaddr,dcdelay,cosx,Loffset 
;;; acc3 Lreadaddr,dcdelay,sinx,Loffset ;alternate, doesn't sound "wide"

	
;;; output values:		
;;; An nicer flanger would interpolate the "in-between values"
;;;   on the delay line
	
	mac_s  outr,Rread,Rsource,forward
	mac_s  outl,Lread,Lsource,forward


;;; feedback and write to the delay line:
	
	mac_s  Rwrite,Rsource,Rread,feedback
	mac_s  Lwrite,Lsource,Lread,feedback
		

	
	end





