/*
 * KJASSwingConsole.java
 *
 * Created on 15. Mai 2002, 23:43
 */

package org.kde.kjas.server;
import java.io.OutputStream;
import java.io.FileOutputStream;
import java.awt.Toolkit;
import java.awt.Image;

/**
 *
 * @author  till
 */
public class KJASSwingConsole extends javax.swing.JFrame implements Console {
    
    private boolean force_append = true;

    /** Creates new form KJASSwingConsole */
    public KJASSwingConsole() {
        initComponents();
        setSize(500, 300);

        java.io.PrintStream st = new java.io.PrintStream( new KJASConsoleStream(this) );
        System.setOut(st);
        System.setErr(st);
        try {
            java.net.URL iconUrl = getClass().getClassLoader().getResource("images/beanicon.png");
            if (iconUrl != null) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                Image icon = tk.createImage(iconUrl);
                setIconImage(icon);
            }
        } catch (Throwable e) {
        }
        System.out.println( "Java VM version: " +
                            System.getProperty("java.version") );
        System.out.println( "Java VM vendor:  " +
                            System.getProperty("java.vendor") );
        String ph = System.getProperty("http.proxyHost");
        String pp = System.getProperty("http.proxyPort");
        if (ph != null) {
            System.out.println("Proxy: " + ph + ":" + pp);
        }
        SecurityManager sec = System.getSecurityManager();
        Main.debug("SecurityManager=" + sec);
        if (sec == null) {
            System.out.println( "WARNING: Security Manager disabled!" );
            textField.setForeground(java.awt.Color.red);
        }
        force_append = false;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel();
        clearButton = new javax.swing.JButton();
        closeButton = new javax.swing.JButton();
        copyButton = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        textField = new javax.swing.JTextArea();

        setTitle("Konqueror Java Console");
        setFont(new java.awt.Font("Monospaced", 0, 10));
        setName("KJAS Console");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel1.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        clearButton.setText("clear");
        clearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearButtonActionPerformed(evt);
            }
        });

        jPanel1.add(clearButton, java.awt.BorderLayout.WEST);

        closeButton.setText("close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });

        jPanel1.add(closeButton, java.awt.BorderLayout.EAST);

        copyButton.setText("copy");
        copyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                copyButtonActionPerformed(evt);
            }
        });

        jPanel1.add(copyButton, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        textField.setColumns(40);
        textField.setEditable(false);
        textField.setRows(10);
        textField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                textFieldKeyPressed(evt);
            }
        });

        jScrollPane1.setViewportView(textField);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void textFieldKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_textFieldKeyPressed
        // Add your handling code here:
        char key = evt.getKeyChar();
        switch (key) {
            case 'h':
                append("Konqueror Java Console Help\n");
                append("  h: show help\n");
                append("  g: run garbage collection\n");
                append("  m: show memory info\n");
                append("  t: list threads\n");
            case 'g':
                append("Running Garbage Collection ...\n");
                System.gc();
            case 'm': 
                append("Total Memory: " + Runtime.getRuntime().totalMemory() + " bytes\n"); 
                append("Free Memory : " + Runtime.getRuntime().freeMemory() + " bytes\n");
                break;
            case 't':
                showThreads();
                break;
        }
    }//GEN-LAST:event_textFieldKeyPressed

    private void showThreads() {
        Thread t = Thread.currentThread();
        ThreadGroup g = t.getThreadGroup();
        ThreadGroup parent;
        while ((parent = g.getParent()) != null) {
            g = parent;
        }
        g.list();
    }
    private void copyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_copyButtonActionPerformed
        // Add your handling code here:
        textField.selectAll();
        textField.copy();
    }//GEN-LAST:event_copyButtonActionPerformed

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        // Add your handling code here:
        setVisible(false);
    }//GEN-LAST:event_closeButtonActionPerformed

    private void clearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearButtonActionPerformed
        // Add your handling code here:
        textField.setText("");;
    }//GEN-LAST:event_clearButtonActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        setVisible(false);
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new KJASSwingConsole().show();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton clearButton;
    private javax.swing.JTextArea textField;
    private javax.swing.JButton closeButton;
    private javax.swing.JButton copyButton;
    // End of variables declaration//GEN-END:variables

    public void append(String txt) {
        if (txt == null || (!isVisible() && !force_append)) {
            return;
        }
        int length = txt.length();
        synchronized(textField) {
            //get the caret position, and then get the new position
            int old_pos = textField.getCaretPosition();
            textField.append(txt);
            textField.setCaretPosition( old_pos + length );
        }
    }
}

