/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "catalogsettings.h"
#include <kconfig.h>
#include <kemailsettings.h>
#include <kglobal.h>
#include <klocale.h>
#include <stdlib.h>
#include <qtextcodec.h>
#include <qregexp.h>

#include <stdlib.h>

const bool           Defaults::Save::autoUpdate=true;
const bool           Defaults::Save::updateLastTranslator=true;
const bool           Defaults::Save::updateRevisionDate=true;
const bool           Defaults::Save::updateLanguageTeam=true;
const bool           Defaults::Save::updateCharset=true;
const bool           Defaults::Save::updateEncoding=true;
const bool           Defaults::Save::updateProject=true;
const bool           Defaults::Save::updateTranslatorCopyright=true;
const CopyrightUpdate Defaults::Save::FSFCopyright=Update;
const bool           Defaults::Save::updateDescription=true;
const FileEncoding   Defaults::Save::encoding=UTF8;
const bool           Defaults::Save::useOldEncoding=true;
const Qt::DateFormat Defaults::Save::dateFormat=Qt::ISODate;
const bool           Defaults::Save::autoSyntaxCheck=true;
const bool	     Defaults::Save::saveObsolete=true;

const QString Defaults::Save::customDateFormat()
{
    return QString("%Y-%m-%d %H:%M%z");
}

QString charsetString(QTextCodec *codec)
{
    QString encodingStr = "";
    if(codec)
    {
        encodingStr = codec->name();
        encodingStr=encodingStr.upper();
	if( encodingStr.startsWith("CP" ) )
    	    encodingStr.replace(QRegExp(" "),"");
	else
    	    encodingStr.replace(QRegExp(" "),"-");
    }

    return encodingStr;
}

QString charsetString(FileEncoding e)
{
    QString encodingStr = "";

    switch(e)
    {
        case Locale:
        {
            QTextCodec *codec=QTextCodec::codecForLocale();
            if(codec)
               encodingStr=charsetString(codec);
            else
               encodingStr="unknown";

            break;
        }
        case UTF8:
        {
            encodingStr="UTF-8";
            break;
        }
        case UTF16:
        {
            encodingStr="UTF-16";
            break;
        }
    }

    return encodingStr;
}

const QString Defaults::Save::projectString()
{
    return QString("@PACKAGE@");
}

const QString Defaults::Save::descriptionString()
{
    return QString("translation of @PACKAGE@.po to @LANGUAGE@");
}

Defaults::Identity::Identity(): numberOfPluralForms(2)
{
    _authorName=QString::null;
    _authorLocalizedName=QString::null;
    _authorEmail=QString::null;
    _mailingList=QString::null;
    _timezone=QString::null;
    _languageName=QString::null;
    _languageCode=QString::null;
}

QString Defaults::Identity::authorName()
{
   if(_authorName.isNull())
   {
       KEMailSettings emSet;
      _authorName=emSet.getSetting(KEMailSettings::RealName);
   }

   return _authorName;
}

QString Defaults::Identity::authorLocalizedName()
{
    _authorLocalizedName=_authorName;
    return _authorLocalizedName;
}

QString Defaults::Identity::authorEmail()
{
   if(_authorEmail.isNull())
   {
       KEMailSettings emSet;
      _authorEmail=emSet.getSetting(KEMailSettings::EmailAddress);
   }

   return _authorEmail;
}

QString Defaults::Identity::mailingList()
{
   if(_mailingList.isNull())
   {
      QString lang=Defaults::Identity::languageCode();
      int temp=lang.find("_");
      lang=lang.left(temp);
      _mailingList=lang+"@li.org";
   }

   return _mailingList;
}

QString Defaults::Identity::languageName()
{
   if(_languageName.isNull())
   {
      _languageName="";
   }

   return _languageName;
}

QString Defaults::Identity::languageCode()
{   
   if(_languageCode.isNull())
   {     
      // first try to get the language from KDE settings
      KLocale *locale = KGlobal::locale();
      QString lang;
      if(locale)
      {
          lang=locale->languageList().first();
      }

      if(lang.isEmpty())
      {
         lang=getenv("LC_ALL");
         if(lang.isEmpty())
         {
            lang=getenv("LC_MESSAGES");
            if(lang.isEmpty())
            {
               lang=getenv("LANG");
            }
         }
      }

      _languageCode=lang;
   }

   return _languageCode;
}

QString Defaults::Identity::timezone()
{
   if(_timezone.isNull())
   {
     _timezone=getenv("TIMEZONE");
     if(_timezone.isEmpty())
       _timezone="GMT";
   }

   return _timezone;
}


const bool Defaults::Misc::useBzip = true;
const bool Defaults::Misc::compressSingleFile = true;

QChar Defaults::Misc::accelMarker()
{
    return QChar('&');
}

QRegExp Defaults::Misc::contextInfo()
{
    return QRegExp("^_:((?!\\\\n\\n).)+\\\\n\\n");
}

QRegExp Defaults::Misc::singularPlural()
{
    return QRegExp("_n:\\s");
}

QStringList Defaults::Tag::expressions()
{
    QStringList list;

    list.append("</[A-Za-z0-9\\n]+>");
    list.append("<[A-Za-z0-9\\n]+[^>]*/?>");
    list.append("http:\\/\\/[a-zA-Z0-9\\.\\-_/~]+");
    list.append("mailto:[a-z0-9\\.\\-_]+@[a-z0-9\\.\\-_]+");
    list.append("<?[a-z0-9\\.\\-_]+@[a-z0-9\\.\\-_]+>?");
    list.append("&[a-z,A-Z,\\-,0-9,#\\.]*;");

    return list;
}
