/*
    cwbugdetails.cpp  -  Details of a bug report

    copyright   : (c) 2001 by Martijn Klingens
    email       : klingens@kde.org

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <qtextview.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlabel.h>

#include "cwbugdetails.h"

#include <khtml_part.h>
#include <khtmlview.h>
#include <kapplication.h>
#include <kdebug.h>

#include <qlayout.h>
#include <qpalette.h>

using namespace KBugBusterMainWindow;

CWBugDetails::CWBugDetails( QWidget *parent , const char * name )
: CWBugDetails_Base( parent, name )
{
    m_bugDesc = new KHTMLPart( m_bugContainer, "m_bugDesc" );
    connect( m_bugDesc->browserExtension(), SIGNAL( openURLRequest( const KURL &, const KParts::URLArgs & ) ),
             this, SLOT( handleOpenURLRequest( const KURL &, const KParts::URLArgs & ) ) );

    m_bugContainerLayout->addWidget( m_bugDesc->view() );
}

CWBugDetails::~CWBugDetails()
{
}

void CWBugDetails::setBug( const Bug &bug, const BugDetails &details )
{
    QString text =
        "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">"
        "<html><head><title></title></head>"
        "<body style=\"margin: 0px\">";

    BugDetailsPart::List bdp = details.parts();
    BugDetailsPart::List::ConstIterator it;
    QColorGroup cg = m_bugDesc->view()->palette().active();
    bool firstHeader = true;

    for ( it = bdp.begin(); it != bdp.end(); ++it ) {
        text.append( QString( "<div style=\"background: %1; "
                              "color: %2; padding: 8px; " )
                              .arg( cg.highlight().name() )
                              .arg( cg.highlightedText().name() ) );
        if( !firstHeader )
            text.append( QString( "border-top: solid %1 1px; " )
                                  .arg( cg.foreground().name() ) );
        else
            firstHeader = false;

        text.append( QString( "border-bottom: solid %1 1px;\">" )
                              .arg( cg.foreground().name() ) );
        QString sender = (*it).sender.fullName( true );
        QString date = (*it).date;
        if ( it == bdp.begin() )
            text.append( "<a href=\"http://bugs.kde.org/show_bug.cgi?id=" + bug.number()
                         + "\">" + i18n("Bug Report</a> from <b>%1</b> (%2)")
                         .arg( sender ).arg( date ) );
        else
            text.append( i18n("Reply from <b>%1</b> (%2)")
                         .arg( sender ).arg( date ) );
        text.append( "</div>" );

        if ( it == bdp.begin() )
        {
            text.append(
                QString( "<div style=\"background: %1; color: %2; "
                         "border-bottom: solid %3 1px; "
                         "padding: 4px\">"
                         "<table cellspacing=\"0\" cellpadding=\"4\">" )
                         .arg( cg.background().name() )
                         .arg( cg.foreground().name() )
                         .arg( cg.foreground().name() ) );
            text.append( textBugDetailsAttribute( details.version(), i18n("Version") ) );
            text.append( textBugDetailsAttribute( details.source(), i18n("Source") ) );
            text.append( textBugDetailsAttribute( details.compiler(), i18n("Compiler") ) );
            text.append( textBugDetailsAttribute( details.os(), i18n("OS") ) );
            text.append( "</table></div>" );
        }

        // Adding of <pre> tags is now done by BugDetailsJob::processNode. This
        // was breaking the display of attachments because they have <br/>\n
        // after each line -> two newlines with <pre>
        text.append( "<div style=\"padding: 8px\">" );
        text.append( (*it).text );
        text.append( "</div>" );
    }

    text.append( "</body></html>" );

//    kdDebug() << "BEGIN OUTPUT" << text << "END OUTPUT" << endl;

    m_bugDesc->view()->setContentsPos(0,0);
    m_bugDesc->begin();
    m_bugDesc->write( text );
    m_bugDesc->end();
}

void CWBugDetails::handleOpenURLRequest( const KURL &url, const KParts::URLArgs & )
{
    kapp->invokeBrowser( url.url() );
}

QString CWBugDetails::textBugDetailsAttribute( const QString &value,
                                               const QString &name )
{
    QString text = "";
    if ( !value.isEmpty() ) {
        text.append( "<tr><td style=\"width: 20%\"><b>" + name + "</b></td>"
                     "<td>" + value + "</td></tr>" );
    }
    return text;
}


#include "cwbugdetails.moc"

/* vim: set et ts=4 sw=4 softtabstop=4: */

