/*****************************************************************************\
  dj3320_cmap.cpp : Implimentation for the DJ3320 color maps

  Copyright (c) 1996 - 2001, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  \***************************************************************************/


#ifdef APDK_DJ3320

#include "config.h"

#include "global_types.h"

APDK_BEGIN_NAMESPACE

// 600x600x1, K    - Plain, Normal, Grey

uint32_t ulMapCROSSBOW_K_6x6x1[] =
{
    255UL, 238UL, 218UL, 204UL, 189UL, 181UL, 171UL, 161UL, 154UL,
    178UL, 168UL, 161UL, 153UL, 148UL, 141UL, 136UL, 130UL, 127UL,
    140UL, 133UL, 129UL, 124UL, 121UL, 116UL, 113UL, 109UL, 106UL,
    115UL, 112UL, 108UL, 104UL, 101UL,  97UL,  95UL,  91UL,  89UL,
     96UL,  94UL,  90UL,  88UL,  85UL,  82UL,  79UL,  77UL,  74UL,
     81UL,  78UL,  76UL,  73UL,  71UL,  69UL,  66UL,  65UL,  62UL,
     67UL,  66UL,  63UL,  62UL,  59UL,  57UL,  55UL,  54UL,  51UL,
     56UL,  55UL,  52UL,  51UL,  49UL,  47UL,  45UL,  44UL,  42UL,
     47UL,  45UL,  43UL,  41UL,  40UL,  38UL,  37UL,  35UL,  33UL,
    209UL, 191UL, 184UL, 173UL, 166UL, 156UL, 151UL, 144UL, 140UL,
    154UL, 149UL, 143UL, 138UL, 132UL, 128UL, 123UL, 120UL, 115UL,
    127UL, 122UL, 119UL, 114UL, 111UL, 107UL, 104UL, 100UL,  96UL,
    106UL, 102UL,  99UL,  95UL,  93UL,  90UL,  87UL,  84UL,  81UL,
     89UL,  85UL,  83UL,  80UL,  78UL,  75UL,  73UL,  70UL,  68UL,
     74UL,  71UL,  69UL,  67UL,  65UL,  63UL,  61UL,  59UL,  57UL,
     62UL,  60UL,  58UL,  56UL,  54UL,  52UL,  50UL,  48UL,  47UL,
     51UL,  50UL,  48UL,  46UL,  44UL,  43UL,  41UL,  39UL,  38UL,
     42UL,  40UL,  38UL,  37UL,  35UL,  34UL,  32UL,  31UL,  29UL,
    176UL, 168UL, 159UL, 153UL, 146UL, 141UL, 135UL, 130UL, 125UL,
    140UL, 133UL, 129UL, 124UL, 121UL, 116UL, 113UL, 109UL, 106UL,
    115UL, 112UL, 108UL, 104UL, 101UL,  97UL,  95UL,  91UL,  89UL,
     96UL,  94UL,  90UL,  88UL,  85UL,  82UL,  79UL,  77UL,  74UL,
     81UL,  78UL,  76UL,  73UL,  71UL,  69UL,  66UL,  65UL,  62UL,
     67UL,  66UL,  63UL,  62UL,  59UL,  57UL,  55UL,  54UL,  51UL,
     56UL,  55UL,  52UL,  51UL,  49UL,  47UL,  45UL,  44UL,  42UL,
     47UL,  45UL,  43UL,  41UL,  40UL,  38UL,  37UL,  35UL,  33UL,
     38UL,  36UL,  34UL,  32UL,  31UL,  29UL,  28UL,  26UL,  25UL,
    153UL, 148UL, 143UL, 136UL, 132UL, 127UL, 122UL, 119UL, 114UL,
    125UL, 122UL, 118UL, 114UL, 110UL, 107UL, 103UL, 100UL,  96UL,
    105UL, 102UL,  98UL,  95UL,  92UL,  90UL,  86UL,  84UL,  81UL,
     88UL,  85UL,  83UL,  80UL,  77UL,  75UL,  72UL,  70UL,  67UL,
     74UL,  71UL,  69UL,  67UL,  65UL,  63UL,  61UL,  59UL,  57UL,
     62UL,  60UL,  58UL,  56UL,  54UL,  52UL,  50UL,  48UL,  47UL,
     51UL,  49UL,  48UL,  46UL,  44UL,  42UL,  41UL,  39UL,  38UL,
     42UL,  40UL,  38UL,  37UL,  35UL,  33UL,  32UL,  30UL,  29UL,
     33UL,  31UL,  30UL,  28UL,  27UL,  25UL,  24UL,  22UL,  21UL,
    138UL, 132UL, 128UL, 123UL, 120UL, 115UL, 112UL, 108UL, 105UL,
    115UL, 111UL, 108UL, 104UL, 101UL,  97UL,  95UL,  91UL,  89UL,
     96UL,  93UL,  90UL,  87UL,  85UL,  81UL,  79UL,  76UL,  74UL,
     81UL,  78UL,  76UL,  73UL,  71UL,  68UL,  66UL,  64UL,  62UL,
     67UL,  66UL,  63UL,  62UL,  59UL,  57UL,  55UL,  53UL,  51UL,
     56UL,  55UL,  52UL,  51UL,  49UL,  47UL,  45UL,  44UL,  42UL,
     46UL,  45UL,  43UL,  41UL,  39UL,  38UL,  36UL,  35UL,  33UL,
     37UL,  36UL,  34UL,  32UL,  31UL,  29UL,  28UL,  26UL,  25UL,
     28UL,  27UL,  26UL,  24UL,  22UL,  21UL,  19UL,  18UL,  16UL,
    124UL, 121UL, 116UL, 113UL, 109UL, 106UL, 102UL,  99UL,  95UL,
    105UL, 102UL,  98UL,  95UL,  92UL,  90UL,  86UL,  83UL,  81UL,
     88UL,  85UL,  82UL,  80UL,  77UL,  75UL,  72UL,  70UL,  67UL,
     73UL,  71UL,  69UL,  67UL,  65UL,  63UL,  60UL,  59UL,  56UL,
     62UL,  60UL,  57UL,  56UL,  54UL,  52UL,  50UL,  48UL,  46UL,
     51UL,  49UL,  48UL,  46UL,  44UL,  42UL,  40UL,  39UL,  37UL,
     42UL,  40UL,  38UL,  37UL,  35UL,  33UL,  32UL,  30UL,  29UL,
     33UL,  31UL,  30UL,  28UL,  27UL,  25UL,  24UL,  22UL,  21UL,
     25UL,  23UL,  22UL,  20UL,  19UL,  17UL,  16UL,  14UL,  12UL,
    114UL, 110UL, 107UL, 103UL, 100UL,  96UL,  94UL,  90UL,  88UL,
     95UL,  93UL,  90UL,  87UL,  84UL,  81UL,  78UL,  76UL,  73UL,
     81UL,  78UL,  76UL,  73UL,  71UL,  68UL,  66UL,  64UL,  62UL,
     67UL,  65UL,  63UL,  61UL,  59UL,  57UL,  55UL,  53UL,  51UL,
     56UL,  54UL,  52UL,  50UL,  49UL,  47UL,  45UL,  43UL,  42UL,
     46UL,  44UL,  43UL,  41UL,  39UL,  38UL,  36UL,  34UL,  33UL,
     37UL,  36UL,  34UL,  32UL,  31UL,  29UL,  28UL,  26UL,  25UL,
     28UL,  27UL,  25UL,  24UL,  22UL,  21UL,  19UL,  18UL,  16UL,
     20UL,  19UL,  17UL,  16UL,  14UL,  13UL,  11UL,  10UL,   8UL,
    104UL, 101UL,  97UL,  95UL,  91UL,  89UL,  85UL,  83UL,  80UL,
     88UL,  85UL,  82UL,  79UL,  77UL,  74UL,  72UL,  69UL,  67UL,
     73UL,  71UL,  69UL,  66UL,  65UL,  62UL,  60UL,  58UL,  56UL,
     62UL,  60UL,  57UL,  56UL,  54UL,  52UL,  50UL,  48UL,  46UL,
     51UL,  49UL,  47UL,  46UL,  44UL,  42UL,  40UL,  39UL,  37UL,
     41UL,  40UL,  38UL,  37UL,  35UL,  33UL,  31UL,  30UL,  28UL,
     32UL,  31UL,  29UL,  28UL,  26UL,  25UL,  23UL,  22UL,  20UL,
     25UL,  23UL,  22UL,  20UL,  19UL,  17UL,  16UL,  14UL,  12UL,
     16UL,  15UL,  13UL,  12UL,  10UL,   9UL,   7UL,   6UL,   4UL,
     95UL,  92UL,  90UL,  86UL,  84UL,  81UL,  78UL,  76UL,  73UL,
     80UL,  78UL,  75UL,  73UL,  70UL,  68UL,  66UL,  64UL,  62UL,
     67UL,  65UL,  63UL,  61UL,  59UL,  57UL,  55UL,  53UL,  51UL,
     56UL,  54UL,  52UL,  50UL,  48UL,  47UL,  45UL,  43UL,  41UL,
     46UL,  44UL,  43UL,  41UL,  39UL,  38UL,  36UL,  34UL,  33UL,
     37UL,  35UL,  34UL,  32UL,  31UL,  29UL,  28UL,  26UL,  25UL,
     28UL,  27UL,  25UL,  24UL,  22UL,  21UL,  19UL,  18UL,  16UL,
     20UL,  19UL,  17UL,  16UL,  14UL,  12UL,  11UL,   9UL,   8UL,
     12UL,  11UL,   9UL,   8UL,   6UL,   5UL,   3UL,   2UL,   0UL
};

// 300x300x1, CMY  - Plain Draft, Color Pen Only

uint32_t ulMapCROSSBOW_CMY_3x3x1[ 9 * 9 * 9 ] =
{
4294967040UL, 2113404672UL, 1273560832UL,  836828928UL,  618004224UL,  450035456UL,
 299040512UL,  131268352UL,   11009792UL, 4288020224UL, 2812804864UL, 1404894976UL,
 751763200UL,  466812672UL,  299040512UL,  164036352UL,   12386048UL,   11009792UL,
4284088064UL, 4284546816UL, 1768554240UL,  864288512UL,  311820032UL,   10288896UL,
  10288896UL,   10026752UL,    9305856UL, 4281859840UL, 4282121984UL, 3108175616UL,
1094844160UL,  457965312UL,    5504768UL,    6160128UL,    6684416UL,    6946560UL,
4280745728UL, 4280811264UL, 4281138944UL, 2267873024UL,  690421504UL,  237829888UL,
   3604224UL,    4325120UL,    4914944UL, 4279959296UL, 4279959296UL, 4280090368UL,
3759996672UL, 1662713600UL,  437649152UL,   85720832UL,    2752256UL,    3404544UL,
4279369472UL, 4279238400UL, 4279172864UL, 4279172864UL, 2567831296UL, 1158610688UL,
 252509952UL,    1244928UL,    2423552UL, 4278714112UL, 4278648576UL, 4278451968UL,
4278451968UL, 3959488256UL, 1963327232UL,  856030976UL,      65280UL,    1244928UL,
4278255360UL, 4278255360UL, 4278255360UL, 4278255360UL, 4278255360UL, 2449538816UL,
1342242560UL,  604045056UL,      65280UL, 4294952448UL, 2281684736UL, 1275068160UL,
 838860544UL,  619970304UL,  451739392UL,  300220160UL,  182517504UL,   11403008UL,
4288659200UL, 3082276352UL, 1457585920UL,  787021568UL,  417398528UL,  249429760UL,
  96468736UL,   11009792UL,    9830144UL, 4283956992UL, 4285267712UL, 1769144064UL,
 797835008UL,  177864448UL,   10092288UL,    9633536UL,    9109248UL,    8650496UL,
4281597696UL, 4282121984UL, 3460300544UL, 1061158656UL,  407568128UL,    5177088UL,
   6291200UL,    6684416UL,    6881024UL, 4280418048UL, 4280418048UL, 4280745728UL,
2217017088UL,  656736000UL,  204078848UL,    3342080UL,    4323072UL,    4980480UL,
4279435008UL, 4279369472UL, 4279369472UL, 3390242560UL, 1410531072UL,  353763072UL,
  85655296UL,    2545920UL,    3329536UL, 4278910720UL, 4278451968UL, 4278255360UL,
4278583040UL, 2148007680UL,  957021952UL,  168491776UL,    1039616UL,    2210816UL,
4278255360UL, 4278255360UL, 4278255360UL, 4278255360UL, 2617310976UL, 1442904832UL,
 704706304UL,   50591488UL,    1035776UL, 4278254336UL, 4278247424UL, 4278248448UL,
4278248448UL, 3154177024UL, 2046882560UL, 1157690112UL,  520157952UL,      65280UL,
4294931456UL, 2633988608UL, 1358923520UL,  788518144UL,  570425088UL,  452984576UL,
 301465344UL,  217054976UL,   12844800UL, 4291981824UL, 3791619072UL, 1459593728UL,
 671088384UL,  318766848UL,  134217472UL,   14745344UL,   12189440UL,   10026752UL,
4285431296UL, 4286684160UL, 1970633984UL,  765258752UL,  160825088UL,    9436928UL,
   9109248UL,    8519424UL,    8060672UL, 4281838080UL, 4282507264UL, 3644831488UL,
1094820352UL,  391169536UL,    5500928UL,    6553344UL,    6881024UL,    6683392UL,
4280279040UL, 4280418048UL, 4280417024UL, 2116142592UL,  606383360UL,  170771968UL,
   3592704UL,    4576512UL,    5168384UL, 4279238400UL, 4279041792UL, 4279172864UL,
2903630848UL, 1259454208UL,  404008448UL,   52080896UL,    2600192UL,    3386624UL,
4278583040UL, 4278255360UL, 4278255360UL, 3573932288UL, 1896203008UL,  856142848UL,
 218737152UL,    1024512UL,    2070528UL, 4278255360UL, 4278238976UL, 4278240000UL,
3959471872UL, 2264971008UL, 1342221824UL,  604023296UL,      41472UL,    1021184UL,
4278238976UL, 4278231552UL, 4278230784UL, 3959464448UL, 2550178304UL, 1761649152UL,
1057007360UL,  469804800UL,      41984UL, 4294918400UL, 3841935104UL, 1426017024UL,
 754933504UL,  419404800UL,  301984768UL,  234880768UL,  184549120UL,   14810880UL,
4294132224UL, 4294922240UL, 1811892992UL,  620718336UL,  134192128UL,   16768256UL,
  16776960UL,   15531776UL,   13041408UL, 4287777280UL, 4289616128UL, 2628208384UL,
 801528064UL,  132220672UL,   13806080UL,   12571136UL,   11198720UL,    9624832UL,
4282733568UL, 4283853568UL, 3528151040UL, 1094796544UL,  408777728UL,    6264064UL,
   6663680UL,    6864640UL,    6665984UL, 4280385792UL, 4280586752UL, 4280382720UL,
2015652608UL,  640248576UL,  204635392UL,    3968256UL,    4759296UL,    5154560UL,
4279150336UL, 4279021824UL, 4279144960UL, 2618459904UL, 1259634176UL,  353729024UL,
  52199680UL,    2786304UL,    3575552UL, 4278238976UL, 4278232832UL, 4278228224UL,
3271922176UL, 1762102528UL,  839353344UL,  218791168UL,    1146112UL,    2063616UL,
4278233600UL, 4278225408UL, 4278224640UL, 3523251456UL, 2113964544UL, 1258324992UL,
 570458368UL,      31232UL,    1013760UL, 4278228224UL, 4278222848UL, 4278222080UL,
3321920768UL, 2264956160UL, 1560313088UL,  989888512UL,  453017088UL,      31232UL,
4294910976UL, 4294912256UL, 2113874944UL,  654256384UL,  301939456UL,  134182144UL,
  67087616UL,   67105536UL,   16776960UL, 4294910976UL, 4294912512UL, 2516526848UL,
 704587264UL,  100614400UL,   16740608UL,   16750592UL,   16758528UL,   15785216UL,
4289341952UL, 4291964416UL, 3167364096UL, 1121788928UL,  268385280UL,   16474112UL,
  14779136UL,   13015040UL,   11379712UL, 4284297984UL, 4285216512UL, 3647154688UL,
1499802112UL,  461190656UL,    8669952UL,    9399296UL,    9404672UL,    8686080UL,
4280957184UL, 4281089792UL, 4280757760UL, 2049584640UL,  757935872UL,  222185472UL,
   4545792UL,    5272832UL,    5471488UL, 4279327744UL, 4279394048UL, 4279323392UL,
2551465984UL, 1209485312UL,  404245248UL,   52581120UL,    3104512UL,    3632128UL,
4278222080UL, 4278216960UL, 4278542336UL, 2902875136UL, 1745509632UL,  856316416UL,
 202136064UL,    1333760UL,    2251776UL, 4278222080UL, 4278216704UL, 4278215424UL,
3154141184UL, 1962960128UL, 1207985408UL,  570449920UL,      23552UL,    1005824UL,
4278220032UL, 4278216704UL, 4278214400UL, 2919259904UL, 2164285440UL, 1509974784UL,
 989880320UL,  453010176UL,      23552UL, 4294906880UL, 4294907136UL, 2818512640UL,
 973017600UL,  184489728UL,   16720384UL,   16734464UL,   16747776UL,   16760576UL,
4294906880UL, 4294906368UL, 3288273152UL, 1073680640UL,  167712768UL,   16722944UL,
  16732928UL,   16742400UL,   16749824UL, 4290320128UL, 4292876032UL, 3789361664UL,
1425216000UL,  318706688UL,   16722432UL,   16731648UL,   15755520UL,   13532416UL,
4285471744UL, 4286192384UL, 3899791104UL, 1752504064UL,  646191104UL,   93856768UL,
  10633728UL,   10639872UL,    9988352UL, 4281803264UL, 4281473792UL, 4030142976UL,
2101091072UL,  910236416UL,  257106944UL,    6305536UL,    7426048UL,    7298048UL,
4279772160UL, 4279707136UL, 4279705344UL, 2451185920UL, 1243291904UL,  454761472UL,
  53228032UL,    3556352UL,    4150016UL, 4278599168UL, 4278597888UL, 4278662656UL,
2852730368UL, 1611281920UL,  856438528UL,  202127104UL,    1522688UL,    2376192UL,
4278210560UL, 4278207488UL, 4278206720UL, 2969583872UL, 1912619264UL, 1157644800UL,
 570441984UL,      16896UL,     999680UL, 4278211584UL, 4278209280UL, 4076881920UL,
2902476544UL, 2113947648UL, 1459636736UL,  922765824UL,  453003008UL,      17408UL,
4294904832UL, 4294904320UL, 3976137216UL, 1711211776UL,  419364864UL,   16714240UL,
  16717568UL,   16729856UL,   16742400UL, 4294904320UL, 4294902528UL, 4160684032UL,
1627324416UL,  419364864UL,   16715008UL,   16720128UL,   16728576UL,   16737536UL,
4290972672UL, 4293395968UL, 3973382144UL, 1778057984UL,  620692992UL,   16714240UL,
  16720896UL,   16727808UL,   16471808UL, 4286385664UL, 4286385152UL, 4219078912UL,
1954548224UL,  915343872UL,  178195456UL,   11345408UL,   12007168UL,   11160320UL,
4282455040UL, 4282257152UL, 4148236032UL, 2168786688UL, 1095438080UL,  358223616UL,
   7019008UL,    8008192UL,    8274944UL, 4280227072UL, 4280029696UL, 4078898944UL,
2317618944UL, 1260982528UL,  556667136UL,   87824896UL,    4663808UL,    5454592UL,
4278982400UL, 4278982400UL, 4278981888UL, 2802652416UL, 1611601920UL,  856627200UL,
 286331392UL,    1844224UL,    2764544UL, 4278199808UL, 4278199296UL, 4278198784UL,
3070239744UL, 1895834624UL, 1090528256UL,  603991040UL,      10496UL,     993792UL,
4278203904UL, 4278202624UL, 4211093248UL, 2801807872UL, 2013278976UL, 1392521984UL,
 905983488UL,  452997632UL,      11776UL, 4294903040UL, 4294902528UL, 4294902528UL,
2516516864UL, 1073676288UL,  268369920UL,   16711680UL,   16715264UL,   16726272UL,
4294901760UL, 4294901760UL, 4294901760UL, 2231304192UL, 1006567424UL,  251592704UL,
  16713984UL,   16717056UL,   16724736UL, 4291166208UL, 4291690496UL, 4089839616UL,
2163212288UL, 1073676288UL,  268369920UL,   16713984UL,   16717568UL,   16724480UL,
4286578688UL, 4286447616UL, 4286382080UL, 2105802752UL, 1150615552UL,  396492800UL,
  11601408UL,   13506560UL,   13250048UL, 4282910464UL, 4282647296UL, 4148494336UL,
2219442176UL, 1196621824UL,  610271232UL,    7405568UL,    8394496UL,    9054720UL,
4280749312UL, 4280551168UL, 3962111488UL, 2318272000UL, 1345390080UL,  691406336UL,
 172099072UL,    5248000UL,    5907456UL, 4279373056UL, 4279306752UL, 4279372032UL,
2450786048UL, 1511458560UL,  840566528UL,  287246080UL,    2756352UL,    3546880UL,
4278520832UL, 4278389760UL, 4278323968UL, 2919435264UL, 1896025344UL, 1107627776UL,
 570756864UL,  117901056UL,    1317632UL, 4278196736UL, 4278195968UL, 4278195968UL,
2852133376UL, 2097158912UL, 1342184448UL,  788536320UL,  436215552UL,       7168UL,
4294901760UL, 4294901760UL, 4294901760UL, 3338600448UL, 1811873792UL,  872349696UL,
 352256000UL,   16711680UL,   16711680UL, 4294901760UL, 4294639616UL, 4294901760UL,
2768175104UL, 1627324416UL,  754909184UL,  301924352UL,   16711680UL,   16711680UL,
4290707456UL, 4289593344UL, 3904307200UL, 2463694848UL, 1576992768UL,  771686400UL,
 268369920UL,   16711680UL,   16711680UL, 4286447616UL, 4286185472UL, 4085121024UL,
2324103168UL, 1503199232UL,  799670272UL,  264175616UL,   13762560UL,   15466496UL,
4283105280UL, 4283105280UL, 3897556992UL, 2404843520UL, 1499463680UL,  862650368UL,
 343212032UL,    8454144UL,    9961472UL, 4281073664UL, 4281204736UL, 3778084864UL,
2369126400UL, 1463353344UL,  842989568UL,  407306240UL,    5439488UL,    6619136UL,
4279369728UL, 4279500800UL, 3776446464UL, 2367356928UL, 1511981056UL,  908132352UL,
 438697984UL,    3211264UL,    4128768UL, 4278517760UL, 4278583296UL, 4278583296UL,
2617704448UL, 1661599744UL, 1040842752UL,  604831744UL,  152174592UL,    2162688UL,
4278190080UL, 4278190080UL, 4278190080UL, 2902458368UL, 2046820352UL, 1342177280UL,
 822083584UL,  436207616UL,          0UL,
};

// 300x300x1, KCMY - Plain Draft, Both Pens

uint32_t ulMapCROSSBOW_KCMY_3x3x1[ 9 * 9 * 9 ] =
{
1802205183UL,   22740362UL,    5832524UL,    5635892UL,    5570340UL,    5308188UL,
   5308180UL,    5504778UL,    5504768UL, 4278239136UL,      65446UL,    4194132UL,
   5308210UL,    5373728UL,    5308182UL,    5504784UL,    5504776UL,    5504768UL,
4278498896UL, 1862336354UL,      65388UL,    2621242UL,    4128540UL,    4718348UL,
   5570304UL,    5177088UL,    5111552UL, 4278758188UL, 4278317636UL, 1291910980UL,
     65356UL,    1638182UL,    2817798UL,    3866368UL,    4325120UL,    4652288UL,
4279018260UL, 4278239016UL, 2717974318UL,  872480562UL,      65330UL,    1113876UL,
   2162432UL,    3407616UL,    4128512UL, 4279147522UL, 4278239002UL, 4009819936UL,
1778450206UL,  604045088UL,      65310UL,     851206UL,    2227968UL,    3079936UL,
4278688260UL, 4278563846UL, 4278244882UL, 2936078096UL, 1375797010UL,  469827346UL,
  16842514UL,     851712UL,    2096896UL, 4278425088UL, 4278428928UL, 4278237184UL,
4093705984UL, 2097217286UL, 1073806598UL,  385941254UL,      65286UL,     917248UL,
4278222592UL, 4278226176UL, 4278232832UL, 4244692736UL, 3288399616UL, 1812004608UL,
 922812160UL,  335609088UL,      65280UL, 3724477142UL,   16718478UL,   33550676UL,
  13303598UL,    9830180UL,    7798550UL,    6553360UL,    6553352UL,    6160128UL,
4282864474UL, 2206438326UL,    6029146UL,    5963570UL,    5766942UL,    5701394UL,
   5766922UL,    5832448UL,    5570304UL, 4280056368UL, 4278842230UL,  320208754UL,
  20249912UL,    4718358UL,    5373702UL,    5439232UL,    5439232UL,    5308160UL,
4279667474UL, 4278433338UL, 1644429122UL,  370278210UL,   69271328UL,    3145472UL,
   4324608UL,    4783872UL,    5046016UL, 4279405826UL, 4278628890UL, 3137404712UL,
1174732586UL,  420805918UL,  237043456UL,    2686720UL,    3735296UL,    4390656UL,
4279077120UL, 4278628358UL, 4278253844UL, 2047147790UL, 1091370762UL,  437649158UL,
 118947584UL,    2490112UL,    3342080UL, 4278619648UL, 4278428416UL, 4278241024UL,
3120627460UL, 1745288960UL,  822869760UL,  302907136UL,     917248UL,    2490112UL,
4278223616UL, 4278226432UL, 4278235904UL, 4278255360UL, 2499870464UL, 1392574208UL,
 637861632UL,  134545152UL,    1048320UL, 4278220544UL, 4278222592UL, 4278230528UL,
4278243072UL, 3170957056UL, 2097217280UL, 1040252672UL,  419495680UL,      65280UL,
4292804720UL,  503119998UL,   16718158UL,   16746540UL,   16771616UL,   29556490UL,
  11271936UL,    9502464UL,    8650496UL, 4285475388UL, 2885626240UL,  167729236UL,
  16758306UL,   15335178UL,   11664640UL,    9699072UL,    7732992UL,    7339776UL,
4282796800UL, 4282866746UL, 2374868552UL,  528613152UL,   88866564UL,    6618880UL,
   6225664UL,    6225664UL,    6618880UL, 4280441088UL, 4280251412UL, 3962958640UL,
1195375408UL,  492044036UL,    5046016UL,    5504768UL,    5766912UL,    5832448UL,
4279527168UL, 4279598848UL, 4246063890UL, 2082471702UL,  909049610UL,  321847040UL,
   3407616UL,    4390656UL,    4914944UL, 4278938880UL, 4278812928UL, 4278698244UL,
3071737090UL, 1595604736UL,  656408320UL,  153026304UL,    3012352UL,    3865344UL,
4278481408UL, 4278222336UL, 4278233856UL, 3892707072UL, 2215182080UL,  973930240UL,
 403700480UL,    1106176UL,    2346496UL, 4278217984UL, 4278220032UL, 4278228992UL,
4144027904UL, 2600525056UL, 1543564288UL,  671150080UL,  134278144UL,    1032960UL,
4278218496UL, 4278221824UL, 4278227200UL, 3959468800UL, 2751510016UL, 1996537088UL,
1107352832UL,  503374848UL,      58368UL, 4291364662UL, 1845428294UL,  150929488UL,
  16717104UL,   16605464UL,   16756486UL,   16774656UL,   12975872UL,   10223360UL,
4287437850UL, 4293789518UL,  553586254UL,   33501734UL,   16739844UL,   16761856UL,
  15924992UL,   12844800UL,   10157824UL, 4283576576UL, 4251463964UL, 2830980654UL,
 820802084UL,  184527360UL,   16776960UL,   12779264UL,   10223360UL,    9240320UL,
4280889344UL, 4281876992UL, 4284576524UL, 2324339712UL,  864667136UL,  108199680UL,
   7339264UL,    7077632UL,    7143168UL, 4279648512UL, 4279782656UL, 4247287040UL,
2957291776UL, 1363851520UL,  440777984UL,    4711424UL,    5896960UL,    6094592UL,
4278996992UL, 4278933248UL, 4279268864UL, 3458382080UL, 1864676864UL,  791131904UL,
 153467392UL,    3259648UL,    4052224UL, 4278408960UL, 4278212864UL, 4278221056UL,
3893081600UL, 2249111296UL, 1057993728UL,  403812352UL,    1223168UL,    2403072UL,
4278213632UL, 4278216960UL, 4278222592UL, 3825248000UL, 2449517056UL, 1459662336UL,
 654355968UL,   83928064UL,    1023488UL, 4278216192UL, 4278217984UL, 4278223104UL,
3523252992UL, 2600507392UL, 1845533440UL, 1057006592UL,  503358720UL,      41216UL,
4290644754UL, 3221159980UL,  905904176UL,   16712244UL,   16584982UL,   16731654UL,
  16744960UL,   16631808UL,   16514816UL, 4287894786UL, 4258923556UL, 1325335340UL,
 134023468UL,   16721664UL,   16735232UL,   16747264UL,   16764416UL,   15793920UL,
4284029696UL, 4286520328UL, 3976146960UL, 1174352154UL,  352274944UL,   16742912UL,
  16755456UL,   16507904UL,   13299712UL, 4281671424UL, 4282459904UL, 4286072320UL,
2610913280UL,  933718016UL,   10648320UL,   11446272UL,   11255552UL,   10407424UL,
4279835904UL, 4280101120UL, 4281418240UL, 3075696896UL, 1566403328UL,  508855296UL,
   5348864UL,    6338816UL,    6733568UL, 4279053568UL, 4279055104UL, 4279519488UL,
3274142208UL, 1965914624UL,  841974016UL,  153847552UL,    3644160UL,    4369664UL,
4278467328UL, 4278337024UL, 4278539264UL, 3574364160UL, 2249424384UL, 1108706048UL,
 420840960UL,    1410816UL,    2592768UL, 4244652800UL, 4244656128UL, 4278214656UL,
3640686336UL, 2415950592UL, 1392540928UL,  671121664UL,   67140096UL,    1016064UL,
4278212096UL, 4278213632UL, 4278216960UL, 3271585536UL, 2516612352UL, 1761637632UL,
1056996096UL,  536903936UL,      30720UL, 4289858560UL, 3841916954UL, 1610547224UL,
 436011032UL,   16712726UL,   16583942UL,   16727040UL,   16738816UL,   16751872UL,
4287892736UL, 4258334214UL, 1862205460UL,  587007244UL,   66915842UL,   16719616UL,
  16730624UL,   16742400UL,   16621568UL, 4284419840UL, 4286648064UL, 4294186498UL,
1727994624UL,  503258880UL,   16591616UL,   16736000UL,   16747776UL,   15970560UL,
4282126848UL, 4282717184UL, 4285997312UL, 2628005888UL, 1101869568UL,  212940544UL,
  12346112UL,   12554240UL,   11838464UL, 4280161792UL, 4280555776UL, 4282656768UL,
2975807744UL, 1667644160UL,  560676352UL,    7427072UL,    8683008UL,    8623360UL,
4279243776UL, 4279310592UL, 4279969024UL, 3526310912UL, 2050178816UL,  960052480UL,
 204690432UL,    3763968UL,    4753664UL, 4278656000UL, 4278590976UL, 4278790400UL,
3641786880UL, 2199208960UL, 1159286016UL,  421090304UL,    1726720UL,    2780160UL,
4278200064UL, 4278202368UL, 4278205952UL, 3523235072UL, 2298497536UL, 1459967488UL,
 704927488UL,  100684544UL,    1137664UL, 4278206208UL, 4244654080UL, 4026552576UL,
3103805696UL, 2466272256UL, 1711298304UL, 1006655744UL,  520117248UL,      22272UL,
4289136640UL, 4293591052UL, 2399076362UL,  973013004UL,  268369930UL,   16712710UL,
  16713984UL,   16723200UL,   16734464UL, 4287760128UL, 4290708224UL, 2835283968UL,
1090322432UL,  234815488UL,   16714240UL,   16717824UL,   16726272UL,   16737792UL,
4285073408UL, 4286645504UL, 4292411392UL, 1979647232UL,  687802368UL,   16714752UL,
  16589824UL,   16729856UL,   16741888UL, 4282648832UL, 4283238400UL, 4286122752UL,
2678526464UL, 1219367680UL,  364254720UL,   12789760UL,   13782272UL,   13268736UL,
4280552704UL, 4280814592UL, 4282716928UL, 2925730560UL, 1701584128UL,  712252928UL,
   7808000UL,    9389824UL,   10055168UL, 4279504640UL, 4279636224UL, 4280489984UL,
3056935168UL, 2000232960UL,  993797120UL,  222177280UL,    4930048UL,    6117632UL,
4278848768UL, 4278784000UL, 4279113472UL, 3709346816UL, 2216371712UL, 1193093120UL,
 555820032UL,    2110464UL,    2901248UL, 4278326016UL, 4278195200UL, 4278197504UL,
3640666112UL, 2248157440UL, 1392782592UL,  738800384UL,  117912576UL,    1194240UL,
4278198528UL, 4278200576UL, 4026544896UL, 2952803328UL, 2365601280UL, 1660958208UL,
 973092864UL,  486553600UL,      13824UL, 4288742656UL, 4292608000UL, 3254714368UL,
1526661120UL,  603783168UL,  201261056UL,   16711936UL,   16713216UL,   16720128UL,
4287628032UL, 4289986560UL, 3640590336UL, 1828651008UL,  721354752UL,  201261056UL,
  16713216UL,   16715776UL,   16722176UL, 4285923840UL, 4287168512UL, 4292018176UL,
2533294080UL, 1140785152UL,  301793280UL,   16582912UL,   16717568UL,   16724736UL,
4282974976UL, 4283367424UL, 4286513152UL, 2812608512UL, 1521483776UL,  481361920UL,
  12322560UL,   14228992UL,   14236160UL, 4280812544UL, 4247454208UL, 4282909440UL,
2909340416UL, 1718551808UL,  796395008UL,  108922624UL,    9379328UL,   10566400UL,
4279633664UL, 4246276096UL, 4280813824UL, 3006794496UL, 1916537856UL, 1010699264UL,
 323226880UL,    5315328UL,    6632960UL, 4278979072UL, 4279044608UL, 4279438592UL,
3021737728UL, 2065764096UL, 1143214080UL,  539431168UL,    2692608UL,    3353344UL,
4278453760UL, 4278323200UL, 4278389504UL, 3641119232UL, 2450002432UL, 1409946624UL,
 722146560UL,  252645120UL,    1385216UL, 4278193408UL, 4278194944UL, 4076870144UL,
3003128576UL, 2298486272UL, 1593843456UL,  905977344UL,  436216064UL,       8448UL,
4292214784UL, 4292804608UL, 3707699200UL, 2097086464UL, 1090453504UL,  503119872UL,
 218038272UL,   67043328UL,   16711680UL, 4287627264UL, 4255580160UL, 4076797952UL,
2399076352UL, 1358888960UL,  603914240UL,  251592704UL,   16711680UL,   16711680UL,
4286316544UL, 4286578688UL, 4291493888UL, 3019833344UL, 1845428224UL,  788463616UL,
 285016064UL,   16711680UL,   16711680UL, 4283367424UL, 4284678144UL, 4287102976UL,
3064594432UL, 2058747904UL,  985268224UL,  364838912UL,   13762560UL,   15466496UL,
4281401344UL, 4282449920UL, 4284088320UL, 3010723840UL, 2004353024UL, 1065418752UL,
 411303936UL,    9437184UL,   10747904UL, 4279762944UL, 4280221696UL, 4281466880UL,
2872836096UL, 2000945152UL, 1095237632UL,  525205504UL,    5505024UL,    6881280UL,
4278845440UL, 4279238656UL, 4279762944UL, 2871066624UL, 2015625216UL, 1143406592UL,
 589889536UL,   86835200UL,    3735552UL, 4278190080UL, 4278190080UL, 4278386688UL,
3053912064UL, 2097807360UL, 1208811520UL,  688848896UL,  185729024UL,    1835008UL,
4278190080UL, 4278190080UL, 4278190080UL, 3154116608UL, 2365587456UL, 1610612736UL,
 905969664UL,  452984832UL,          0UL,
};

// 600x600x1, CMY  - Plain Normal, Color Pen Only

uint32_t ulMapCROSSBOW_CMY_6x6x1[ 9 * 9 * 9 ] =
{
2223280896UL, 1065201920UL,  645257728UL,  426833408UL,  309133056UL,  225181440UL,
 157941504UL,   74055424UL,    5570304UL, 2638978560UL, 1414832896UL,  710860544UL,
 392756992UL,  225181440UL,  157941504UL,   73793280UL,    6225664UL,    5570304UL,
3509429504UL, 2217782016UL,  892713728UL,  440593664UL,  155975424UL,    5242624UL,
   5177088UL,    5045248UL,    4713216UL, 3978078976UL, 2988354560UL, 1562556416UL,
 555865088UL,  220720384UL,    2811904UL,    3127296UL,    3387648UL,    3518720UL,
4279479296UL, 3793006080UL, 2568466944UL, 1159187200UL,  336839424UL,  118933760UL,
   1811712UL,    2199296UL,    2460416UL, 4279084288UL, 4279086848UL, 3171856896UL,
1880015616UL,  839769344UL,  218873088UL,   34451200UL,    1347328UL,    1735168UL,
4278821632UL, 4278758400UL, 3792155136UL, 2634530048UL, 1309070336UL,  587712000UL,
 134660096UL,     630272UL,    1211904UL, 4278493184UL, 4278429440UL, 4278367488UL,
3137518848UL, 1996540672UL,  990038272UL,  436387072UL,      49920UL,     627968UL,
4278228992UL, 4278230528UL, 4278231808UL, 3372263168UL, 2315298560UL, 1224776704UL,
 671127552UL,  302032896UL,      47104UL, 2341233920UL, 1168007168UL,  663458304UL,
 428059648UL,  310036736UL,  225959168UL,  158593024UL,   91291392UL,    5763840UL,
2807062784UL, 1549559808UL,  728937728UL,  393602304UL,  208730368UL,  124780288UL,
  39976704UL,    5568768UL,    4972288UL, 3660349696UL, 2570492416UL,  892965120UL,
 407357696UL,   89063168UL,    5174784UL,    4909056UL,    4641792UL,    4375296UL,
4179268096UL, 3508448000UL, 1746967808UL,  539003904UL,  203793152UL,    2599424UL,
   3187712UL,    3384320UL,    3449600UL, 4279277056UL, 4279282176UL, 2735975168UL,
1125292032UL,  336758016UL,  102011136UL,    1673728UL,    2194688UL,    2523392UL,
4278820096UL, 4278823680UL, 3372856576UL, 1728684032UL,  722046720UL,  185304064UL,
  34439424UL,    1273344UL,    1665024UL, 4278557696UL, 4278363904UL, 3842026496UL,
2332205056UL, 1074040320UL,  486900992UL,   84246528UL,     552704UL,    1072640UL,
4278228480UL, 4278226432UL, 3321924608UL, 2432731136UL, 1325433600UL,  721452544UL,
 352353536UL,   33717504UL,     550912UL, 4278222848UL, 3791680000UL, 3036705536UL,
2466280192UL, 1577088768UL, 1040219136UL,  587234304UL,  268468224UL,      33792UL,
2828417536UL, 1336884480UL,  683361536UL,  396192768UL,  277583872UL,  226733056UL,
 159237632UL,  108649728UL,    6542336UL, 3043571968UL, 1887519488UL,  731075072UL,
 345211904UL,  159949056UL,   75608320UL,    7388416UL,    6142720UL,    5090048UL,
3711385600UL, 2806075136UL,  993738496UL,  391018240UL,   72131584UL,    4763136UL,
   4566016UL,    4300800UL,    4034816UL, 4280047104UL, 3894505984UL, 1847614464UL,
 555831808UL,  187262208UL,    2783488UL,    3310336UL,    3441408UL,    3375104UL,
4279267840UL, 4279273216UL, 2702213120UL, 1074816000UL,  303191808UL,   85419008UL,
   1796352UL,    2321408UL,    2584320UL, 4278747904UL, 4278620928UL, 3221720832UL,
1460237056UL,  654926080UL,  202004480UL,   34429184UL,    1332992UL,    1726208UL,
4278356992UL, 4278225408UL, 3221259008UL, 1812099072UL,  956457728UL,  436492800UL,
 100947200UL,     545280UL,    1068032UL, 4278223104UL, 3657457920UL, 2852152064UL,
1996513280UL, 1140874240UL,  671111168UL,  302011904UL,      20992UL,     478208UL,
3976224768UL, 3137360128UL, 2650820608UL, 1979732224UL, 1275089152UL,  889213440UL,
 536892672UL,  234902528UL,      21248UL, 3147636992UL, 1940792320UL,  736634624UL,
 400699392UL,  212946432UL,  161117696UL,  110007808UL,   92580608UL,    7516416UL,
3413910016UL, 2576754688UL,  916923904UL,  314258688UL,   78728960UL,    9793280UL,
   8881920UL,    7770624UL,    6592512UL, 3897173248UL, 3042454784UL, 1314137088UL,
 409218304UL,   74466304UL,    6903040UL,    6318336UL,    5599744UL,    4812544UL,
4280494848UL, 3895145984UL, 1797662976UL,  555819776UL,  204421632UL,    3164928UL,
   3299328UL,    3432704UL,    3300352UL, 4279255296UL, 4279388416UL, 2383428352UL,
1007826432UL,  320091648UL,  102317568UL,    1984256UL,    2379776UL,    2577408UL,
4278670592UL, 4278606080UL, 2768718080UL, 1326007296UL,  638205952UL,  185286144UL,
  34488576UL,    1393152UL,    1787904UL, 4278214656UL, 4278211840UL, 2852145920UL,
1661094400UL,  889472768UL,  419709440UL,  101007104UL,     605952UL,    1064448UL,
4278211840UL, 3271575040UL, 2617263360UL, 1795180288UL, 1073759744UL,  637551360UL,
 285229312UL,      15872UL,     474112UL, 3707783936UL, 2868920320UL, 2348826112UL,
1677737472UL, 1140866816UL,  788545280UL,  486555648UL,  218120192UL,      15872UL,
3466662400UL, 2477528064UL, 1055004160UL,  335483904UL,  167714304UL,   80624384UL,
  44717824UL,   43612672UL,    8883968UL, 3716354560UL, 2896041216UL, 1286673408UL,
 349246208UL,   47849728UL,   11417856UL,   10112256UL,    8870912UL,    7958272UL,
4032173312UL, 3513456384UL, 1583813120UL,  577704448UL,  126033408UL,    8401152UL,
   7488000UL,    6638848UL,    5722624UL, 4281276928UL, 3845528576UL, 1848775936UL,
 758256896UL,  222173952UL,    4400896UL,    4798208UL,    4800768UL,    4343040UL,
4279573760UL, 4279640064UL, 2199131904UL, 1024792320UL,  387389440UL,  102704128UL,
   2305792UL,    2636544UL,    2768640UL, 4278791680UL, 4278792192UL, 2584291072UL,
1275732992UL,  604709888UL,  202122752UL,   34679296UL,    1585152UL,    1849088UL,
4278205952UL, 4227872000UL, 2684497920UL, 1459826176UL,  872754944UL,  436547072UL,
 101068288UL,     667136UL,    1125888UL, 4278205952UL, 3137352704UL, 2466263552UL,
1577070848UL,  989868544UL,  603992576UL,  285225216UL,      11776UL,     470272UL,
3556784896UL, 2734699520UL, 2214604800UL, 1476407296UL, 1090531584UL,  771764736UL,
 486551808UL,  218116608UL,      11776UL, 3717990912UL, 2762738432UL, 1439959808UL,
 503253248UL,  100600576UL,   16716032UL,   15412480UL,   12404480UL,   10772736UL,
3850701312UL, 3231713536UL, 1672808704UL,  550373632UL,   81202176UL,   12785408UL,
  11151872UL,    9845760UL,    8932096UL, 4183624448UL, 3748793088UL, 1919879424UL,
 729417984UL,  159910400UL,    9311488UL,    8857344UL,    7943424UL,    6831872UL,
4281863680UL, 3896315136UL, 1966672640UL,  876284672UL,  323095552UL,   38539776UL,
   5317120UL,    5385728UL,    4994304UL, 4280029440UL, 3558411520UL, 2031881472UL,
1042156800UL,  455150848UL,  120197632UL,    3218432UL,    3745792UL,    3681792UL,
4278981120UL, 4278915840UL, 2433421312UL, 1242370048UL,  621613056UL,  218959360UL,
  35002624UL,    1778176UL,    2107648UL, 4278394624UL, 4278394112UL, 2684623616UL,
1443109632UL,  822418176UL,  436608000UL,  101063680UL,     728576UL,    1188352UL,
4278200320UL, 3405783552UL, 2466259200UL, 1493180672UL,  956309760UL,  587211264UL,
 285221120UL,       8704UL,     467200UL, 3657444096UL, 2634032896UL, 2080384000UL,
1459627008UL, 1073751040UL,  738206976UL,  469771520UL,  218113024UL,       8704UL,
3852011008UL, 2980840704UL, 1992492288UL,  855572992UL,  218038272UL,   16712960UL,
  16714496UL,   15213568UL,   13515776UL, 3985048832UL, 3516924416UL, 2108751872UL,
 818282496UL,  215023616UL,   13174272UL,   12062720UL,   10953216UL,   10301952UL,
4284679680UL, 3950314240UL, 1986789376UL,  897450496UL,  311034624UL,    9307392UL,
   9507328UL,    9183232UL,    8399872UL, 4282255104UL, 3946776064UL, 2117927936UL,
 977274112UL,  457704704UL,   89130496UL,    5705472UL,    6036480UL,    5646080UL,
4280355328UL, 3458140160UL, 2099316480UL, 1092814592UL,  556205824UL,  187566080UL,
   3542272UL,    4004096UL,    4203008UL, 4279241472UL, 3322808576UL, 2047870976UL,
1158809600UL,  638847232UL,  269945088UL,   35523840UL,    2364672UL,    2694400UL,
4278586112UL, 4278586112UL, 2550532864UL, 1426459392UL,  822545408UL,  436734976UL,
 151587072UL,     922112UL,    1382400UL, 4278194944UL, 3892318720UL, 2566918400UL,
1543508480UL,  956305920UL,  553652736UL,  301995520UL,       5120UL,     529664UL,
4278196992UL, 2818578688UL, 2147489792UL, 1409292544UL, 1006639616UL,  687872512UL,
 452991744UL,  218110208UL,       5888UL, 3952673280UL, 3282764288UL, 2444952064UL,
1273495552UL,  553582592UL,  150929408UL,   16711680UL,   16713472UL,   16325888UL,
4136042496UL, 3331391488UL, 2173894656UL, 1118109696UL,  498794496UL,  130416640UL,
  12780544UL,   12258048UL,   11409920UL, 4284743680UL, 3513253888UL, 2086993920UL,
1081671680UL,  545783808UL,  143720448UL,    9634816UL,    9767936UL,    9509120UL,
4282384384UL, 3795845120UL, 2201878528UL, 1061289984UL,  575406080UL,  189923328UL,
   5833472UL,    6818816UL,    6756096UL, 4280550400UL, 3408003584UL, 2099445760UL,
1109721088UL,  606732288UL,  305201152UL,    3735552UL,    4197120UL,    4592896UL,
4229170688UL, 2987525120UL, 1981022976UL, 1175913216UL,  689505024UL,  337314560UL,
  86115072UL,    2624000UL,    3019264UL, 4278781440UL, 3272148224UL, 2164851712UL,
1242170368UL,  772473856UL,  420283392UL,  152044544UL,    1378304UL,    1773568UL,
4278322688UL, 3976332800UL, 2516715008UL, 1476527616UL,  956433920UL,  570558208UL,
 285345792UL,   67372032UL,     658688UL, 4278193408UL, 3221228288UL, 2264926976UL,
1442843904UL, 1040190720UL,  671092224UL,  402656768UL,  218107904UL,       3584UL,
3517579264UL, 3232497664UL, 2628648960UL, 1690697728UL,  922681344UL,  452919296UL,
 184483840UL,   16711680UL,   16711680UL, 4135911424UL, 2927493120UL, 2223439872UL,
1385693184UL,  816709632UL,  398655488UL,  164691968UL,   14286848UL,   14483456UL,
4083220480UL, 2857893888UL, 1968963584UL, 1248722944UL,  796983296UL,  395247616UL,
 127401984UL,   10092544UL,   10551296UL, 3795845120UL, 2822569984UL, 2051014656UL,
1178861568UL,  760086528UL,  408223744UL,  140509184UL,    6881280UL,    7798784UL,
3844472832UL, 2753953792UL, 1965621248UL, 1210843136UL,  758120448UL,  439746560UL,
 171638784UL,    4259840UL,    4980736UL, 4078305280UL, 2853634048UL, 1914241024UL,
1192951808UL,  740098048UL,  421527552UL,  203685888UL,    2686976UL,    3342336UL,
3708354560UL, 2701787136UL, 1913389056UL, 1192034304UL,  772800512UL,  454033408UL,
 219348992UL,    1638400UL,    2097152UL, 4278321152UL, 3171090432UL, 2214789120UL,
1308884992UL,  839188480UL,  520421376UL,  302383104UL,   67698688UL,    1048576UL,
4278190080UL, 3707764736UL, 2449473536UL, 1459617792UL, 1040187392UL,  687865856UL,
 419430400UL,  218103808UL,          0UL,
};

// 600x600x1, KCMY - Plain Normal, Both Pens

uint32_t ulMapCROSSBOW_KCMY_6x6x1[ 9 * 9 * 9 ] =
{
1667460522UL,    5504834UL,   55181096UL,   71892759UL,   54853391UL,   21233415UL,
   4390658UL,    4259584UL,    4259584UL, 4281573684UL,  353763144UL,  408157981UL,
 189726476UL,   21167875UL,    4456192UL,    4456192UL,    4456192UL,    4456192UL,
4281698828UL, 3072977179UL, 1094827786UL,  558092038UL,  172155136UL,    4317952UL,
   4579584UL,    4646144UL,    4648192UL, 4280780290UL, 4281187844UL, 2066795265UL,
 875869440UL,  405846272UL,   53393664UL,    3320576UL,    3583232UL,    3782400UL,
4279927552UL, 4280068865UL, 3072250624UL, 1394720000UL,  555856640UL,  237154048UL,
   2203904UL,    2658048UL,    2919168UL, 4279271936UL, 4279344384UL, 3843086592UL,
1830074112UL,  974566656UL,  370586880UL,  102149376UL,    1872128UL,    2260736UL,
4278876928UL, 4278882560UL, 4178168576UL, 2198646016UL, 1343138560UL,  705606400UL,
 218810624UL,    1027328UL,    1672960UL, 4278481408UL, 4278421248UL, 4211127040UL,
2634457344UL, 1628019456UL, 1024107264UL,  520536320UL,   50585344UL,     894208UL,
4278216448UL, 4278220288UL, 3875572480UL, 2600500736UL, 1711306752UL, 1124104192UL,
 671121664UL,  352368896UL,      57600UL, 4059111242UL,  385824056UL,  248873752UL,
  62373127UL,    9693952UL,    7864064UL,    6356736UL,    5373696UL,    4849408UL,
4282402090UL, 1717989922UL,  846238991UL,  426033411UL,   39714048UL,    5766912UL,
   5437184UL,    5239040UL,    5239552UL, 4281687559UL, 3477375245UL, 1380547844UL,
 709527809UL,  222669056UL,    4374272UL,    4571904UL,    4571904UL,    4573952UL,
4280446208UL, 4147159297UL, 1848802816UL,  926120960UL,  439516928UL,   70226688UL,
   3381504UL,    3645696UL,    3844864UL, 4279529728UL, 4279999232UL, 2166260480UL,
1243774208UL,  589527296UL,  253918208UL,    2194944UL,    2653184UL,    2982144UL,
4278940416UL, 4279014144UL, 2668725504UL, 1544911616UL,  873888000UL,  370571520UL,
 102136320UL,    1733888UL,    2125824UL, 4278480896UL, 4278225408UL, 2902883840UL,
1779070720UL, 1141667584UL,  655193856UL,  202144256UL,     882688UL,    1470464UL,
4278215936UL, 3909121536UL, 2936042752UL, 1929605888UL, 1376023040UL,  872772352UL,
 486897664UL,   67403264UL,     816640UL, 4278217472UL, 3707792384UL, 3036704512UL,
2113957888UL, 1577086464UL, 1073769728UL,  671117568UL,  335578368UL,      38144UL,
4259523106UL, 1291788578UL,  620576270UL,  147284481UL,   10845440UL,    9282304UL,
   8110848UL,    7530240UL,    6422272UL, 4285282322UL, 2508540682UL, 1065963269UL,
 444424450UL,   41317632UL,    7376128UL,    6791936UL,    6075136UL,    5620992UL,
4282006016UL, 3276953600UL, 1381129728UL,  760243200UL,  256406784UL,    4492544UL,
   4628224UL,    4630272UL,    4630272UL, 4280370944UL, 3475987968UL, 1798593536UL,
 909532416UL,  456549632UL,   87257344UL,    3570944UL,    3836160UL,    3969792UL,
4279390464UL, 3608830976UL, 2048942336UL, 1176723456UL,  589520640UL,  253977600UL,
   2189824UL,    2715904UL,    3110912UL, 4278802688UL, 3708577792UL, 2232509440UL,
1427399168UL,  857039104UL,  404054016UL,  101999616UL,    1663744UL,    2122752UL,
4278214144UL, 3707922432UL, 2466669568UL, 1611162368UL, 1057579008UL,  621437184UL,
 252338432UL,     679680UL,    1335040UL, 4278215424UL, 3338690560UL, 2533384704UL,
1811964416UL, 1258447104UL,  822239232UL,  453140992UL,  100819968UL,     614144UL,
4009779968UL, 3204471552UL, 2566937344UL, 1929403904UL, 1426087424UL, 1023434240UL,
 671113216UL,  335570432UL,      27136UL, 4291177476UL, 2382177033UL, 1105276673UL,
 417279744UL,   12011264UL,   10314752UL,    9271552UL,    8493312UL,    8044800UL,
4286786051UL, 2676962304UL, 1300576000UL,  612973056UL,   92358144UL,    8018944UL,
   7630592UL,    7175168UL,    6722304UL, 4283248640UL, 2874751232UL, 1532443392UL,
 794574336UL,  257640192UL,    5985536UL,    6121216UL,    5862400UL,    5405696UL,
4280757248UL, 3241360128UL, 1781873664UL,  960053504UL,  490358784UL,  121000960UL,
   3630336UL,    3895552UL,    4027904UL, 4279382016UL, 3374137856UL, 1948271360UL,
1193625088UL,  640042752UL,  270879744UL,    2380288UL,    2907904UL,    3238144UL,
4278729728UL, 3238873600UL, 2064664576UL, 1393903872UL,  857099008UL,  420891136UL,
 102124544UL,    1789952UL,    2250496UL, 4278208768UL, 3238219008UL, 2164608000UL,
1577602304UL, 1024085248UL,  621432064UL,  252332800UL,     674048UL,    1330176UL,
4177549056UL, 3003141376UL, 2231389184UL, 1694518528UL, 1191267840UL,  788614656UL,
 436293120UL,  100813824UL,     543488UL, 3707785984UL, 2902477824UL, 2231388928UL,
1811959040UL, 1342196736UL,  956321024UL,  654331392UL,  335564288UL,      19712UL,
4290516992UL, 3120109568UL, 1306336256UL,  567614976UL,  165093376UL,   12007680UL,
  10441472UL,    9529600UL,    9141504UL, 4286781440UL, 2643008768UL, 1401496064UL,
 730407936UL,  277817344UL,    8861184UL,    8145920UL,    7691520UL,    7433728UL,
4283899904UL, 2740528128UL, 1532634624UL,  861874176UL,  392309504UL,    6436352UL,
   6571776UL,    6510336UL,    6251264UL, 3979814656UL, 2704877568UL, 1715284480UL,
1010772480UL,  524430336UL,  105067008UL,    4735232UL,    4935936UL,    4872960UL,
4279968000UL, 3139446784UL, 1931749632UL, 1244081152UL,  707407872UL,  304690432UL,
   2637312UL,    3034112UL,    3298816UL, 4245299200UL, 3272617728UL, 2048077824UL,
1377186048UL,  857223936UL,  404239360UL,  119027712UL,    1916416UL,    2377728UL,
4278399232UL, 3037018112UL, 2080716544UL, 1510422272UL, 1040922624UL,  621492224UL,
 252393216UL,     801024UL,    1391360UL, 4009771776UL, 2768256256UL, 2080389632UL,
1627404800UL, 1174486272UL,  788610304UL,  452999936UL,  117454848UL,     473088UL,
3439347200UL, 2634039040UL, 2063612928UL, 1677736960UL, 1308638720UL,  922762752UL,
 654327040UL,  335559424UL,      14848UL, 4289662208UL, 3455388160UL, 1507659008UL,
 668405760UL,  265753088UL,   64558080UL,   12398336UL,   11225088UL,   10444544UL,
4286516224UL, 2810908160UL, 1502155008UL,  797643776UL,  311367168UL,   76749312UL,
   9121024UL,    8339200UL,    8016640UL, 4284158464UL, 2707034880UL, 1566381312UL,
 929175296UL,  459544576UL,  107354880UL,    6827008UL,    6897152UL,    6704128UL,
3644463104UL, 2604406784UL, 1715476992UL, 1044585216UL,  608574464UL,  206118144UL,
   4991232UL,    5388800UL,    5326080UL, 3575979008UL, 2535857152UL, 1797856512UL,
1210850816UL,  724442368UL,  321920768UL,    3286528UL,    3748608UL,    4013568UL,
4279376128UL, 3071548416UL, 2014780672UL, 1394154752UL,  924458752UL,  488448256UL,
 135996928UL,    1977856UL,    2504704UL, 4278524416UL, 3171427072UL, 2131239936UL,
1510548736UL, 1007363328UL,  621618688UL,  269297408UL,     928256UL,    1388288UL,
4278201344UL, 2868914944UL, 2063608320UL, 1560291840UL, 1090529536UL,  755116800UL,
 436284416UL,  100739328UL,     469504UL, 3540006144UL, 2499817984UL, 1962946560UL,
1593847552UL, 1241526016UL,  905981696UL,  620769024UL,  335555840UL,      11008UL,
4288742912UL, 3790536704UL, 1877803776UL,  820839680UL,  334300928UL,  116066048UL,
  48434944UL,   13314048UL,   12271616UL, 4286186496UL, 3045786112UL, 1636369408UL,
 915342848UL,  429197312UL,  160893440UL,    9768704UL,    9643520UL,    9386240UL,
4283958784UL, 2875131392UL, 1633682944UL,  996411392UL,  526911744UL,  157944320UL,
   7081984UL,    7283968UL,    7288320UL, 3711830784UL, 2638154496UL, 1732512512UL,
1078397696UL,  659164416UL,  290196736UL,    5116416UL,    5579520UL,    5780480UL,
3240694016UL, 2435452672UL, 1764495104UL, 1211043584UL,  758124544UL,  389222400UL,
  70586624UL,    3874816UL,    4337408UL, 3407483648UL, 2501579520UL, 1797001728UL,
1277039360UL,  891294464UL,  505483776UL,  153228032UL,    2497280UL,    2828288UL,
4278915072UL, 3037466880UL, 2064388864UL, 1477317632UL,  990778624UL,  672077312UL,
 286331904UL,    1055232UL,    1516032UL, 4278194944UL, 3103856896UL, 2113935104UL,
1577064448UL, 1056970752UL,  754981376UL,  436411392UL,  117578496UL,     466176UL,
4043318016UL, 2701140480UL, 1962942720UL, 1526735360UL, 1140859392UL,  855646464UL,
 587210752UL,  335552512UL,       7936UL, 4288414464UL, 3957522432UL, 2381381632UL,
1174208512UL,  419364864UL,   83820544UL,   16711680UL,   16714240UL,   14884864UL,
4285857792UL, 3011379200UL, 1803747328UL, 1133576192UL,  563806208UL,  211746816UL,
  27460096UL,   10553088UL,   10952192UL, 4283891712UL, 2875195392UL, 1717698560UL,
1147600896UL,  661323776UL,  275709952UL,    7405568UL,    7604224UL,    7871744UL,
3812688384UL, 2705391616UL, 1766195200UL, 1128857600UL,  709623808UL,  340590592UL,
 105971712UL,    5638400UL,    6102272UL, 3240953344UL, 2536375296UL, 1798308352UL,
1228014080UL,  791937536UL,  456524544UL,  154600192UL,    3868928UL,    4397824UL,
3139373824UL, 2367620864UL, 1763640832UL, 1260455168UL,  857867520UL,  522388736UL,
 220529920UL,    2557952UL,    3020544UL, 3507555072UL, 2601584896UL, 1863387136UL,
1309804288UL,  907216640UL,  622069504UL,  320144896UL,    1444096UL,    1839872UL,
4278454016UL, 3137668352UL, 2114193152UL, 1560545280UL, 1074006272UL,  738462208UL,
 470027008UL,  117901312UL,     528384UL, 4278193408UL, 3170897664UL, 2080378880UL,
1577062656UL, 1157632512UL,  838865664UL,  570429696UL,  318771968UL,       4864UL,
4293066752UL, 4076797952UL, 3036610560UL, 1509883904UL,  603914240UL,  218038272UL,
  50266112UL,   16711680UL,   16711680UL, 4285857792UL, 3179216896UL, 2056060928UL,
1469775872UL,  866844672UL,  448069632UL,  230359040UL,  130088960UL,   13041664UL,
4150591488UL, 2808086528UL, 1835270144UL, 1349124096UL,  913309696UL,  527826944UL,
 276430848UL,  159121408UL,    8323072UL, 3309699072UL, 2504458240UL, 1800011776UL,
1280180224UL,  894566400UL,  576061440UL,  291045376UL,  123469824UL,    6225920UL,
2905669632UL, 2234646528UL, 1748238336UL, 1295515648UL,  892993536UL,  607911936UL,
 305987584UL,  104726528UL,    4390912UL, 3105947648UL, 2267152384UL, 1696858112UL,
1260781568UL,  891813888UL,  589824000UL,  338296832UL,  103481344UL,    3145728UL,
3138387968UL, 2299723776UL, 1729363968UL, 1259732992UL,  907476992UL,  639107072UL,
 370671616UL,  119144448UL,    2031616UL, 3875864576UL, 2768699392UL, 1946681344UL,
1393033216UL,  973602816UL,  688455680UL,  453640192UL,  185270272UL,     917504UL,
4278190080UL, 3137339392UL, 2130706432UL, 1610612736UL, 1174405120UL,  855638016UL,
 587202560UL,  352321536UL,          0UL,
};

APDK_END_NAMESPACE

#endif
