 /***************************************************************************
    plugin_katexmltools.cpp
    $Id: plugin_katexmltools.h,v 1.7 2002/07/20 14:06:20 dnaber Exp $
    copyright            : (C) 2001-2002 by Daniel Naber
    email                : daniel.naber@t-online.de
 ***************************************************************************/
 
/***************************************************************************
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ***************************************************************************/

#ifndef _PLUGIN_KANT_XMLTOOLS_H
#define _PLUGIN_KANT_XMLTOOLS_H

#include "pseudo_dtd.h"

#include <qstring.h>
#include <qlistbox.h>
#include <qprogressdialog.h>
#include <qptrdict.h>

#include <kate/plugin.h>
#include <kate/application.h>
#include <kate/view.h>
#include <kate/document.h>
#include <kate/documentmanager.h>
#include <kate/mainwindow.h>
#include <kate/viewmanager.h>

#include <ktexteditor/codecompletioninterface.h>

#include <kcombobox.h>
#include <kdialog.h>
#include <kdialogbase.h>
#include <klibloader.h>

class KatePluginFactory : public KLibFactory
{

Q_OBJECT

public:
	KatePluginFactory();
	virtual ~KatePluginFactory();

	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0, const char* name = "QObject", const QStringList &args = QStringList() );

private:
	static KInstance* s_instance;

};

class PluginKateXMLTools : public Kate::Plugin, Kate::PluginViewInterface
{

Q_OBJECT

public:

	PluginKateXMLTools( QObject* parent = 0, const char* name = 0 );
	virtual ~PluginKateXMLTools();
	void addView (Kate::MainWindow *win);
        void removeView(Kate::MainWindow *win);
    
        
public slots:

	void getDTD();

	void slotInsertElement();
	void slotCloseElement();
	void filterInsertString(KTextEditor::CompletionEntry *ce, QString *str);
	void completionDone(KTextEditor::CompletionEntry completion_entry);
	void completionAborted();
	
	void slotFinished(KIO::Job *job);
	void slotData(KIO::Job *, const QByteArray &data);

	void backspacePressed();
	void emptyKeyEvent();
	void keyEvent(int, int, const QString &);

protected:

	static QStringList sortQStringList(QStringList list);
	//bool eventFilter(QObject *object, QEvent *event);

	QString insideTag(Kate::View &kv);
	QString insideAttribute(Kate::View &kv);

	bool isOpeningTag(QString tag);
	bool isClosingTag(QString tag);
	bool isEmptyTag(QString tag);
	bool isQuote(QString ch);
	
	QString getParentElement(Kate::View &view, bool ignore_single_bracket);

	enum Mode {none, entities, attributevalues, attributes, elements};
	enum PopupMode {no_popup, tagname, attributename, attributevalue, entityname};

	QValueList<KTextEditor::CompletionEntry> stringListToCompletionEntryList(QStringList list);

	QString m_dtd_string;
	QString m_url_string;
	
	uint m_last_line, m_last_col;
	QStringList m_last_allowed;
	int m_popup_open_col;

	Mode m_mode;
	int m_correct_pos;

    // code completion stuff:
    KTextEditor::CodeCompletionInterface* m_codeInterface;

	QPtrDict<PseudoDTD> m_dtds;

	QPtrList<class PluginView> m_views;      
};

class InsertElement : public KDialogBase
{

Q_OBJECT

public:
	InsertElement(QWidget *parent, const char *name);
	~InsertElement();
	QString showDialog(QStringList &completions);

};

#endif // _PLUGIN_KANT_XMLTOOLS_H
