/***************************************************************************
                          weatherlib.h  -  description
                             -------------------
    begin                : Wed Jul 5 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WEATHERLIB_H
#define WEATHERLIB_H
#include <qobject.h>
#include <qstring.h>
#include <qptrlist.h>
#include <qregexp.h>
#include <qdict.h>

#include <kio/job.h>

class WeatherLib : public QObject
{
	Q_OBJECT
	
	public:
		class Data;

		WeatherLib(QObject *parent =0L, const char *name ="");
		virtual ~WeatherLib();

		QString temperature(QString stationID);
		QString dewPoint(QString stationID);
		QString relHumidity(QString stationID);
		QString heatIndex(QString stationID);
		QString windChill(QString stationID);
		QString wind(QString stationID);
		QString pressure(QString stationID);
		QString currentIcon(QString stationID);
		QString date(QString stationID);
		QStringList weather(QString stationID);
		QString visibility(QString stationID);
		QStringList cover(QString stationID);
		QStringList stations();
		
		void update(QString stationID);
		void blockingUpdate(QString stationID);
		void remove(QString stationID);
		
	signals:
		void fileUpdateing(const QString &stationID);
		void fileUpdate(const QString &stationID);
		
	private slots:
		void slotCopyDone(KIO::Job*);
		//void slotUpdate()
	private:
		
		bool parsePressure(QString tag, Data *d);
		bool parseVisibility(QString tag, Data *d);
		bool parseTime(QString tag, Data *d);
		bool parseTemperature(QString tag, Data *d);
		bool parseDate(QString tag, Data *d);
		bool parseCurrent(QString tag, Data *d);
		bool parseCover(QString tag, Data *d);
		bool parseWindSpeed(QString tag, Data *d);
		void calcCurrentIcon(Data *d);
		void calcWindChill(Data *d);

		Data* findData(QString stationID);
		void clearData(Data *d);
		void getData(Data *d);
		void processData(QString metar, Data *d);

		QRegExp WindRegExp;
		QRegExp VisRegExp;
		QRegExp TempRegExp;
		QRegExp CoverRegExp;
		QRegExp CurrentRegExp;
		QRegExp TimeRegExp;
		QRegExp DateRegExp;
		QRegExp PressRegExp;

		bool MetricMode;

		QDict<Data> data;
		bool fileDownloaded;
};

#endif
