//-*-C++-*-
/*
**************************************************************************

                          pmsphere.h  -  description
                             -------------------
    begin                : Wed Jun 6 2001
    copyright            : (C) 2001 by Philippe Van Hecke
    email                : lephiloux@tiscalinet.be
    and                  : (C) 2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMSPHERE_H
#define PMSPHERE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmsolidobject.h"
#include "pmvector.h"
#include "pmviewstructure.h"

/**
 * Class for povray sphere.
 */
class PMSphere : public PMSolidObject
{
   typedef PMSolidObject Base;

public:
   /** Create an empty Sphere */
   PMSphere( );
   /** Delete the PMSphere */
   virtual ~PMSphere( );

   /** */
   virtual PMObject* newObject( ) const { return new PMSphere( ); }
   /** */
   virtual QString className( ) const { return QString( "sphere" ); }
   /** */
   virtual PMObjectType type( ) const { return PMTSphere; }
   /** */
   virtual QString description( ) const;
   /** */
   virtual bool isA( PMObjectType t ) const;
   
   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   /** Returns a new @ref PMSphereEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** Returns the name of the pixmap that is displayed in the tree view
    * and dialog view */
   virtual QString pixmap( ) const { return QString( "pmsphere" ); }

   /** Returns the centre of the sphere */
   PMVector centre( ) const { return m_centre; }
   /** Set the centre of the sphere */
   void setCentre( const PMVector& centre );
   /** returns the radius of the sphere */
   double radius( ) const { return m_radius; }
   /** Sets the radius of the sphere */
   void setRadius( double radius );

   /** */
   virtual void restoreMemento( PMMemento* s );
   /** */
   virtual void controlPoints( PMControlPointList& list );
   /** */
   virtual void controlPointsChanged( PMControlPointList& list );

   /** Sets the number of latitutes */
   static void setUSteps( int u );
   /** Sets the number of longitudes */
   static void setVSteps( int v );
   /** Returns the number or latitutes */
   static int uSteps( ) { return s_uStep; }
   /** Returns the number or longitudes */
   static int vSteps( ) { return s_vStep; }
   /** */
   virtual void cleanUp( ) const;
   
protected:
   /** */
   virtual bool isDefault( );
   /** */
   virtual void createViewStructure( );
   /** */
   virtual PMViewStructure* defaultViewStructure( ) const;
   /** */
   virtual int viewStructureParameterKey( ) const { return s_parameterKey; }

private:
   /** Creates the points for the view structure */
   static void createPoints( PMPointArray& points, const PMVector& centre,
                             double radius );
   
   enum PMSphereMementoID { PMRadiusID, PMCentreID };
   /** Radius of the sphere */
   double m_radius;
   /** centre of the sphere */
   PMVector m_centre;
   
   static PMViewStructure* s_pDefaultViewStructure;
   static int s_vStep;
   static int s_uStep;
   static int s_parameterKey;
};


#endif
