/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.graphics.Bitmap;
import android.os.Environment;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.Sleeper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RobotiumUtils {
    private final Instrumentation inst;
    private final Sleeper sleeper;
    private final ActivityUtils activityUtils;
    private final String LOG_TAG = "Robotium";

    public RobotiumUtils(Instrumentation inst, ActivityUtils activityUtils, Sleeper sleeper) {
        this.inst = inst;
        this.activityUtils = activityUtils;
        this.sleeper = sleeper;
    }

    public void sendKeyCode(int keycode) {
        try {
            this.inst.sendCharacterSync(keycode);
        }
        catch (SecurityException e) {
            Assert.assertTrue((String)"Can not complete action!", (boolean)false);
        }
    }

    public void goBack() {
        this.sleeper.sleep();
        try {
            this.inst.sendKeyDownUpSync(4);
            this.sleeper.sleep();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T extends View> ArrayList<T> removeInvisibleViews(ArrayList<T> viewList) {
        ArrayList<View> tmpViewList = new ArrayList<View>(viewList.size());
        for (View view : viewList) {
            if (view == null || !view.isShown()) continue;
            tmpViewList.add(view);
        }
        return tmpViewList;
    }

    public static <T extends View> ArrayList<T> filterViews(Class<T> classToFilterBy, ArrayList<View> viewList) {
        ArrayList<T> filteredViews = new ArrayList<T>(viewList.size());
        for (View view : viewList) {
            if (view == null || !classToFilterBy.isAssignableFrom(view.getClass())) continue;
            filteredViews.add(classToFilterBy.cast(view));
        }
        viewList = null;
        return filteredViews;
    }

    public static ArrayList<View> filterViewsToSet(Class<View>[] classSet, ArrayList<View> viewList) {
        ArrayList<View> filteredViews = new ArrayList<View>(viewList.size());
        block0: for (View view : viewList) {
            if (view == null) continue;
            for (Class<View> filter : classSet) {
                if (!filter.isAssignableFrom(view.getClass())) continue;
                filteredViews.add(view);
                continue block0;
            }
        }
        return filteredViews;
    }

    public static int checkAndGetMatches(String regex, TextView view, Set<TextView> uniqueTextViews) {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            pattern = Pattern.compile(regex, 16);
        }
        Matcher matcher = pattern.matcher(((Object)view.getText()).toString());
        if (matcher.find()) {
            uniqueTextViews.add(view);
        }
        if (view.getError() != null && (matcher = pattern.matcher(((Object)view.getError()).toString())).find()) {
            uniqueTextViews.add(view);
        }
        if (((Object)view.getText()).toString().equals("") && view.getHint() != null && (matcher = pattern.matcher(((Object)view.getHint()).toString())).find()) {
            uniqueTextViews.add(view);
        }
        return uniqueTextViews.size();
    }

    public void takeScreenshot(final View view, final String name) {
        this.activityUtils.getCurrentActivity(false).runOnUiThread(new Runnable(){

            public void run() {
                if (view != null) {
                    view.destroyDrawingCache();
                    view.buildDrawingCache(false);
                    Bitmap b = view.getDrawingCache();
                    FileOutputStream fos = null;
                    SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy-hhmmss");
                    String fileName = null;
                    fileName = name == null ? sdf.format(new Date()).toString() + ".jpg" : name + ".jpg";
                    File directory = new File(Environment.getExternalStorageDirectory() + "/Robotium-Screenshots/");
                    directory.mkdir();
                    File fileToSave = new File(directory, fileName);
                    try {
                        fos = new FileOutputStream(fileToSave);
                        if (!b.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos)) {
                            Log.d((String)"Robotium", (String)"Compress/Write failed");
                        }
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception e) {
                        Log.d((String)"Robotium", (String)"Can't save the screenshot! Requires write permission (android.permission.WRITE_EXTERNAL_STORAGE) in AndroidManifest.xml of the application under test.");
                        e.printStackTrace();
                    }
                    view.destroyDrawingCache();
                }
            }
        });
    }
}

